//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[RWւ̃Ro[^
 * @author Junpee
 */

#include <LampBasic.h>
#include "SceneToCollisionConverter.h"
#include <Core/InputOutput/FilePath.h>
#include <Graphics/Scene/Scene.h>
#include <Graphics/SceneNode/SceneNode.h>
#include <Collision/Renderer/CollisionRenderer.h>
#include <Collision/System/CollisionScene.h>
#include <Collision/Converter/CollisionConverter.h>
#include <Collision/InputOutput/TextCollisionSaver.h>

/*
#include <Collision/InputOutput/TextCollisionLoader.h>
#include <Collision/System/CollisionNode.h>
#include <Collision/Leaf/StaticSphereCollision.h>
*/
//------------------------------------------------------------------------------
// vOGg|Cg
int WINAPI WinMain(
	HINSTANCE instance, HINSTANCE previousInstance, LPSTR command, int show){
	SceneToCollisionConverter sceneToCollisionConverter(command);
	return sceneToCollisionConverter.execute(instance);
}
//------------------------------------------------------------------------------
// RXgN^
SceneToCollisionConverter::SceneToCollisionConverter(const String& command) :
	SceneFramework("SceneToCollisionConverter"), command_(command),
	collisionScene_(NULL), collisionRenderer_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
SceneToCollisionConverter::~SceneToCollisionConverter(){
}
//------------------------------------------------------------------------------
// 
bool SceneToCollisionConverter::initialize(){
	if(command_.isEmpty()){
		ErrorOut("SceneToCollisionConverter::initialize() "
			"t@Cw肵Ă");
		return false;
	}
	FilePath filePath(command_);
	if(!loadScene(filePath.getPath())){
		ErrorOut("SceneToCollisionConverter::initialize() "
			"V[̃[hɎs܂ %s", filePath.getPath().getBytes());
		return false;
	}

	// RWRo[g
	collisionScene_ = new CollisionScene();
	CollisionConverter converter;
	converter.convert(scene_, collisionScene_);

	// RWۑ
	String fileName = filePath.getFolderPath() + filePath.getName() + ".tcl";
	TextCollisionSaver* saver = new TextCollisionSaver();
	saver->save(fileName, collisionScene_);
	delete saver;
/*
	// [_̃eXg
	collisionScene_->clear();
	TextCollisionLoader* loader = new TextCollisionLoader();
	loader->load(fileName, collisionScene_);
	delete loader;

	// eXg
	StaticSphereCollision* sphere =
		collisionScene_->createStaticSphereCollision("sphere");
	sphere->setSphere(Vector3(0.f, 1.f, 0.f), 0.5f);
	collisionScene_->getRootNode()->addChild(sphere);
*/
	// RW_
	collisionRenderer_ = new CollisionRenderer();

	// ʏ̃V[\Ȃ悤ɂ
	scene_->getRootNode()->setEnabled(false);
	return true;
}
//------------------------------------------------------------------------------
// n
void SceneToCollisionConverter::finalize(){
	// RW_폜
	SafeDelete(collisionRenderer_);
	// RW̍폜
	if(collisionScene_ != NULL){
		collisionScene_->clear();
		delete collisionScene_;
	}
}
//------------------------------------------------------------------------------
// s
void SceneToCollisionConverter::run(){
	// ʏV[̕\ؑ
	if(keyboard_->down(Keyboard::keyS)){
		scene_->getRootNode()->setEnabled(!scene_->getRootNode()->isEnabled());
	}
	// RWV[̃go[X
	collisionScene_->traverse();
}
//------------------------------------------------------------------------------
// _O
void SceneToCollisionConverter::renderSetup(){
	collisionRenderer_->renderingSetup(
		collisionScene_, scene_->getCurrentCamera());
}
//------------------------------------------------------------------------------
// _O
void SceneToCollisionConverter::render(){
	collisionRenderer_->rendering();
}
//------------------------------------------------------------------------------
// `
void SceneToCollisionConverter::drawInformation(){
	SceneFramework::drawInformation();
}
//------------------------------------------------------------------------------
