//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[IveB}CUwb_
 * @author Junpee
 */

#ifndef SCENE_OPTIMIZER_H_
#define SCENE_OPTIMIZER_H_

namespace Lamp{
	class Scene;
	class AnimationManager;
	class TextReader;
};

//------------------------------------------------------------------------------
/**
 * V[IveB}CU
 */
class SceneOptimizer{
public:
	/**
	 * RXgN^
	 */
	SceneOptimizer();

	/**
	 * fXgN^
	 */
	virtual ~SceneOptimizer();

	/**
	 * s
	 * @return main̕ԂlB0Ȃ琳I
	 */
	virtual int run();

protected:
	/**
	 * R}hC̓ǂݍ
	 * @return true
	 */
	virtual bool readCommandLine();

	/**
	 * G[`FbN
	 * @return true
	 */
	virtual bool errorCheck();

	/**
	 * V[̃[h
	 * @return true
	 */
	virtual bool loadScene();

	/**
	 * V[̃Z[u
	 * @return true
	 */
	virtual bool saveScene();

	/**
	 * Aj[Ṽ[h
	 * @return true
	 */
	virtual bool loadAnimation();

	/**
	 * Aj[ṼZ[u
	 * @return true
	 */
	virtual bool saveAnimation();

private:
	// Rs[RXgN^̉B
	SceneOptimizer(const SceneOptimizer& copy);

	// Rs[̉B
	void operator =(const SceneOptimizer& copy);

	// V[
	String sceneName_;
	// Aj[V
	String animationName_;
	// R}h
	String commandName_;
	// V[
	Scene* scene_;
	// Aj[V}l[W
	AnimationManager* animationManager_;
	// [_
	TextReader* reader_;

};

//------------------------------------------------------------------------------
#endif // End of SCENE_OPTIMIZER_H_
//------------------------------------------------------------------------------
