//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * 
 * @author Junpee
 */

#include "stdafx.h"
#include "SceneOptimizer.h"
#include "Core/Utility/StringTokenizer.h"
#include "Core/InputOutput/FilePath.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/InputOutput/TextSceneLoader.h"
#include "Graphics/InputOutput/BinarySceneLoader.h"
#include "Graphics/InputOutput/TextSceneSaver.h"
#include "Graphics/InputOutput/BinarySceneSaver.h"
#include "Animation/System/AnimationManager.h"
#include "Animation/System/Animation.h"
#include "Animation/InputOutput/TextAnimationLoader.h"
#include "Animation/InputOutput/TextAnimationSaver.h"
#include "Core/InputOutput/TextFileReader.h"
#include "Graphics/SceneFilter/SceneFilter.h"

//------------------------------------------------------------------------------
// Gg|Cg
int _tmain(int argc, _TCHAR* argv[]){
	if(argc == 1){
		printf("gp@\n"
			"@-scene [filename] V[t@Cw肵܂B\n"
			"@-animation [filename] Aj[Vt@Cw肵܂B\n"
			"@-command [filename] R}ht@Cw肵܂B\n");
		return 0;
	}
	SceneOptimizer optimizer;
	return optimizer.run();
}
//------------------------------------------------------------------------------
// RXgN^
SceneOptimizer::SceneOptimizer() :
	scene_(NULL), animationManager_(NULL), reader_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
SceneOptimizer::~SceneOptimizer(){
	SafeDelete(reader_);
	if(animationManager_ != NULL){
		animationManager_->clear();
		delete animationManager_;
		animationManager_ = NULL;
	}
	if(scene_ != NULL){
		scene_->clear();
		LampGraphics::destroyScene(scene_);
		scene_ = NULL;
	}
}
//------------------------------------------------------------------------------
// s
int SceneOptimizer::run(){
	// R}hC
	if(!readCommandLine()){ return 1; }
	// G[`FbN
	if(!errorCheck()){ return 1; }
	// V[̃[h
	if(!loadScene()){ return 1; }
	// Aj[Ṽ[h
	if(!loadAnimation()){ return 1; }
	// R}h̃[h
	reader_ = new TextFileReader(commandName_);
	// tB^
	SceneFilter sceneFilter(scene_);
	while(!reader_->isEnd()){
		String command = reader_->readLine();
		if(command.getSize() == 0){ continue; }
		if(!sceneFilter.filter(command)){
			ErrorOut("tB^Ɏs܂\n%s\n", command.getBytes());
			return 1;
		}
	}
	// V[̃Z[u
	if(!saveScene()){ return 1; }
	// Aj[ṼZ[u
	if(!saveAnimation()){ return 1; }
	return 0;
}
//------------------------------------------------------------------------------
// R}hC̓ǂݍ
bool SceneOptimizer::readCommandLine(){
	String command(GetCommandLine());
	StringTokenizer tokenizer(command);
	while(tokenizer.hasMoreTokens()){
		String token = tokenizer.getNextToken();
		if(token == "-scene"){
			// V[̓ǂݍ
			if(!tokenizer.hasMoreTokens()){
				ErrorOut("-sceneIvVݒ肳Ă܂A"
					"V[܂\n");
				return false;
			}
			sceneName_ = tokenizer.getNextToken();
		}else if(token == "-animation"){
			// Aj[V̓ǂݍ
			if(!tokenizer.hasMoreTokens()){
				ErrorOut("-animationIvVݒ肳Ă܂A"
					"Aj[V܂\n");
				return false;
			}
			animationName_ = tokenizer.getNextToken();
		}else if(token == "-command"){
			// R}h̓ǂݍ
			if(!tokenizer.hasMoreTokens()){
				ErrorOut("-commandIvVݒ肳Ă܂A"
					"R}h܂\n");
				return false;
			}
			commandName_ = tokenizer.getNextToken();
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// G[`FbN
bool SceneOptimizer::errorCheck(){
	if((sceneName_.getSize() == 0) && (animationName_.getSize() == 0)){
		ErrorOut("V[AAj[VɎw肳Ă܂\n");
		return false;
	}
	if(sceneName_.getSize() != 0){
		FilePath sceneFilePath(sceneName_);
		if(!sceneFilePath.existFile()){
			ErrorOut("V[t@C݂܂\n%s\n",
				sceneName_.getBytes());
			return false;
		}
	}
	if(animationName_.getSize() != 0){
		FilePath animationFilePath(animationName_);
		if(!animationFilePath.existFile()){
			ErrorOut("Aj[Vt@C݂܂\n%s\n",
				animationName_.getBytes());
			return false;
		}
	}
	if(commandName_.getSize() == 0){
		ErrorOut("R}hw肳Ă܂\n");
		return false;
	}
	FilePath commandFilePath(commandName_);
	if(!commandFilePath.existFile()){
		ErrorOut("R}ht@C݂܂\n%s\n",
			commandName_.getBytes());
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
// V[̃[h
bool SceneOptimizer::loadScene(){
	if(sceneName_.getSize() == 0){ return true; }
	FilePath sceneFilePath(sceneName_);
	if(sceneFilePath.getExtension() == "tsn"){
		scene_ = LampGraphics::createScene(sceneFilePath.getName());
		TextSceneLoader* loader = new TextSceneLoader();
		loader->load(sceneFilePath.getPath(), scene_);
		delete loader;
	}else if(sceneFilePath.getExtension() == "bsn"){
		scene_ = LampGraphics::createScene(sceneFilePath.getName());
		BinarySceneLoader* loader = new BinarySceneLoader();
		loader->load(sceneFilePath.getPath(), scene_);
		delete loader;
	}else{
		ErrorOut("gq܂\n%s\n",
			sceneName_.getBytes());
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
// V[̃Z[u
bool SceneOptimizer::saveScene(){
	if(scene_ == NULL){ return true; }
	FilePath sceneFilePath(sceneName_);
	if(sceneFilePath.getExtension() == "tsn"){
		TextSceneSaver* textSceneSaver = new TextSceneSaver();
		textSceneSaver->save(sceneFilePath.getPath(), scene_);
		delete textSceneSaver;
	}else if(sceneFilePath.getExtension() == "bsn"){
		BinarySceneSaver* binarySceneSaver = new BinarySceneSaver();
		binarySceneSaver->save(sceneFilePath.getPath(), scene_);
		delete binarySceneSaver;
	}else{
		ErrorOut("gq܂\n%s\n",
			sceneName_.getBytes());
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
// Aj[Ṽ[h
bool SceneOptimizer::loadAnimation(){
	if(animationName_.getSize() == 0){ return true; }
	FilePath animationFilePath(animationName_);
	if(animationFilePath.getExtension() == "tam"){
		animationManager_ = new AnimationManager();
		TextAnimationLoader* loader = new TextAnimationLoader();
		loader->load(animationFilePath.getPath(), animationManager_);
		delete loader;
	}else{
		ErrorOut("gq܂\n%s\n",
			animationName_.getBytes());
		return false;
	}
	// V[΃oCh
	if(scene_ != NULL){
		Animation* animation =
			animationManager_->search(animationFilePath.getName());
		if(animation == NULL){
			ErrorOut("[gAj[V܂\n%s\n",
				animationFilePath.getName().getBytes());
			return false;
		}
		if(!animation->bind(scene_)){
			ErrorOut("Aj[ṼoChɎs܂\n");
			return false;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// Aj[ṼZ[u
bool SceneOptimizer::saveAnimation(){
	if(animationManager_ == NULL){ return true; }
	FilePath animationFilePath(animationName_);
	if(animationFilePath.getExtension() == "tam"){
		TextAnimationSaver* textAnimationSaver = new TextAnimationSaver();
		textAnimationSaver->save(
			animationFilePath.getPath(), animationManager_);
		delete textAnimationSaver;
	}else{
		ErrorOut("gq܂\n%s\n",
			animationName_.getBytes());
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
