//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * TEhTv ÓITEh
 * @author Junpee
 */

#include <LampBasic.h>
#include <Framework/System/BasicFramework.h>
#include <Sound/System/LampSound.h>
#include <Sound/System/SoundManager.h>
#include <Sound/Stereo/StaticSound.h>
#include <Sound/Stereo/StreamSound.h>//

// Lamp̃l[Xy[XLɂ
using namespace Lamp;

//------------------------------------------------------------------------------
// NX`Bʏ̓wb_t@CɊi[
//------------------------------------------------------------------------------
/**
 * TEhTv ÓITEh
 */
class SampleSoundStaticSound : public BasicFramework{
public:
	/**
	 * RXgN^
	 */
	SampleSoundStaticSound(const String& command) :
	  BasicFramework("SampleSoundStaticSound"), command_(command){}

	/**
	 * 
	 * @return ɐtrueԂ
	 */
	virtual bool initialize();

	/**
	 * n
	 */
	virtual void finalize();

	/**
	 * s
	 */
	virtual void run();

	/**
	 * `
	 */
	virtual void drawInformation();

private:
	// R}h
	String command_;
	// 񕶎
	String informationString_;
	// TEh
	StaticSound* sound_;
//	StreamSound* sound_;

};
//------------------------------------------------------------------------------
// vOGg|Cg
//------------------------------------------------------------------------------
// C֐
int WINAPI WinMain(
	HINSTANCE instance, HINSTANCE previousInstance, LPSTR command, int show){
	SampleSoundStaticSound tutorial(command);
	return tutorial.execute(instance);
}
//------------------------------------------------------------------------------
// NX
//------------------------------------------------------------------------------
// 
bool SampleSoundStaticSound::initialize(){
	sound_ = LampSound::getSoundManager()->createStaticSound(
		"../../Media/Sound/SampleSE1.ogg");
	if(sound_ != NULL){
		sound_->applyCommentOption();
		sound_->play();
	}
/*
	sound_ = LampSound::getSoundManager()->createStreamSound(command_);
	if(sound_ != NULL){
		sound_->applyCommentOption();
		sound_->play();
	}
*/
	return true;
}
//------------------------------------------------------------------------------
// n
void SampleSoundStaticSound::finalize(){
	LampSound::getSoundManager()->destroy(sound_);
}
//------------------------------------------------------------------------------
// s
void SampleSoundStaticSound::run(){
	if(sound_ != NULL){ informationString_ += sound_->toString(); }
	// TEhGfB^𓱓
}
//------------------------------------------------------------------------------
// `
void SampleSoundStaticSound::drawInformation(){
	BasicFramework::drawInformation();
	drawInformationString(informationString_);
	informationString_ = "";
}
//------------------------------------------------------------------------------
