//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ̓Tv pbh
 * @author Junpee
 */

#include <LampBasic.h>
#include <Framework/System/BasicFramework.h>
#include <Input/System/LampInput.h>
#include <Input/Pad/PS2Pad.h>
#include <Input/Pad/SFPad.h>
#include <Core/Utility/FPSController.h>

// Lamp̃l[Xy[XLɂ
using namespace Lamp;

//------------------------------------------------------------------------------
// NX`Bʏ̓wb_t@CɊi[
//------------------------------------------------------------------------------
/**
 * ̓Tv pbh
 */
class SampleInputPad : public BasicFramework{
public:
	/**
	 * RXgN^
	 */
	SampleInputPad(): BasicFramework("SampleInputPad") ,
		ps2Pad_(NULL), sfPad_(NULL){}

	/**
	 * 
	 * @return ɐtrueԂ
	 */
	virtual bool initialize();

	/**
	 * n
	 */
	virtual void finalize();

	/**
	 * s
	 */
	virtual void run();

	/**
	 * `
	 */
	virtual void drawInformation();

private:
	// 񕶎
	String informationString_;
	// PS2݊pbh
	PS2Pad* ps2Pad_;
	// SF݊pbh
	SFPad* sfPad_;

};
//------------------------------------------------------------------------------
// vOGg|Cg
//------------------------------------------------------------------------------
// C֐
int WINAPI WinMain(
	HINSTANCE instance, HINSTANCE previousInstance, LPSTR command, int show){
	SampleInputPad tutorial;
	return tutorial.execute(instance);
}
//------------------------------------------------------------------------------
// NX
//------------------------------------------------------------------------------
// 
bool SampleInputPad::initialize(){
	int joystickCount = LampInput::getJoystickCount();
	for(int i = 0; i < joystickCount; i++){
		Joystick* joystick = LampInput::getJoystick(i);
		if((ps2Pad_ == NULL) &&
			PS2Pad::checkCompatibility(joystick)){
			ps2Pad_ = new PS2Pad(joystick);
		}else if((sfPad_ == NULL) &&
			SFPad::checkCompatibility(joystick)){
			sfPad_ = new SFPad(joystick);
		}
	}

	// FPS̐ݒ(`30FPSɗƂĂQ[60FPSœmFł)
	fpsController_->setTargetInterval(FPSController::interval30FPS);
	return true;
}
//------------------------------------------------------------------------------
// n
void SampleInputPad::finalize(){
	SafeDelete(sfPad_);
	SafeDelete(ps2Pad_);
}
//------------------------------------------------------------------------------
// s
void SampleInputPad::run(){
	if(ps2Pad_ != NULL){ informationString_ += ps2Pad_->toString() + "\n"; }
	if(sfPad_ != NULL){ informationString_ += sfPad_->toString() + "\n"; }
}
//------------------------------------------------------------------------------
// `
void SampleInputPad::drawInformation(){
	BasicFramework::drawInformation();
	drawInformationString(informationString_);
	informationString_ = "";
}
//------------------------------------------------------------------------------
