//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ̓Tv O
 * @author Junpee
 */

#include <LampBasic.h>
#include <Framework/System/BasicFramework.h>
#include <Input/System/LampInput.h>
#include <Input/Keyboard/Keyboard.h>
#include <Input/Mouse/Mouse.h>
#include <Input/Joystick/Joystick.h>
#include <Core/Utility/FPSController.h>

/// O擾Ȃ0AOĐȂ1
#define LOG_MODE 0

// Lamp̃l[Xy[XLɂ
using namespace Lamp;

//------------------------------------------------------------------------------
// NX`Bʏ̓wb_t@CɊi[
//------------------------------------------------------------------------------
/**
 * ̓Tv O
 */
class SampleInputLogging : public BasicFramework{
public:
	/**
	 * RXgN^
	 */
	SampleInputLogging() : BasicFramework("SampleInputLogging"){}

	/**
	 * 
	 * @return ɐtrueԂ
	 */
	virtual bool initialize();

	/**
	 * s
	 */
	virtual void run();

	/**
	 * `
	 */
	virtual void drawInformation();

private:
	// 񕶎
	String informationString_;

};
//------------------------------------------------------------------------------
// vOGg|Cg
//------------------------------------------------------------------------------
// C֐
int WINAPI WinMain(
	HINSTANCE instance, HINSTANCE previousInstance, LPSTR command, int show){
	SampleInputLogging tutorial;
	return tutorial.execute(instance);
}
//------------------------------------------------------------------------------
// NX
//------------------------------------------------------------------------------
// 
bool SampleInputLogging::initialize(){
	// FPS̐ݒ(`30FPSɗƂĂQ[60FPSœmFł)
	fpsController_->setTargetInterval(FPSController::interval30FPS);

#if (LOG_MODE == 0)
	// O̎擾Jn
	LampInput::startLogging();
#elif (LOG_MODE == 1)
	// O̍ĐJn
	LampInput::playLog();
#endif
	return true;
}
//------------------------------------------------------------------------------
// s
void SampleInputLogging::run(){
	informationString_ += keyboard_->toString() + "\n";
	informationString_ += mouse_->toString() + "\n";
	int joystickCount = LampInput::getJoystickCount();
	for(int i = 0; i < joystickCount; i++){
		informationString_ += LampInput::getJoystick(i)->toString() + "\n";
	}
}
//------------------------------------------------------------------------------
// `
void SampleInputLogging::drawInformation(){
	BasicFramework::drawInformation();
	drawInformationString(informationString_);
	informationString_ = "";
}
//------------------------------------------------------------------------------
