//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ̓Tv WCXeBbN
 * @author Junpee
 */

#include <LampBasic.h>
#include <Framework/System/BasicFramework.h>
#include <Input/System/LampInput.h>
#include <Input/Joystick/Joystick.h>
#include <Core/Utility/FPSController.h>

// Lamp̃l[Xy[XLɂ
using namespace Lamp;

//------------------------------------------------------------------------------
// NX`Bʏ̓wb_t@CɊi[
//------------------------------------------------------------------------------
/**
 * ̓Tv WCXeBbN
 */
class SampleInputJoystick : public BasicFramework{
public:
	/**
	 * RXgN^
	 */
	SampleInputJoystick(): BasicFramework("SampleInputJoystick"){}

	/**
	 * 
	 * @return ɐtrueԂ
	 */
	virtual bool initialize();

	/**
	 * s
	 */
	virtual void run();

	/**
	 * `
	 */
	virtual void drawInformation();

private:
	// 񕶎
	String informationString_;

};
//------------------------------------------------------------------------------
// vOGg|Cg
//------------------------------------------------------------------------------
// C֐
int WINAPI WinMain(
	HINSTANCE instance, HINSTANCE previousInstance, LPSTR command, int show){
	SampleInputJoystick tutorial;
	return tutorial.execute(instance);
}
//------------------------------------------------------------------------------
// NX
//------------------------------------------------------------------------------
// 
bool SampleInputJoystick::initialize(){
	// FPS̐ݒ(`30FPSɗƂĂQ[60FPSœmFł)
	fpsController_->setTargetInterval(FPSController::interval30FPS);
	return true;
}
//------------------------------------------------------------------------------
// s
void SampleInputJoystick::run(){
	int joystickCount = LampInput::getJoystickCount();
	for(int i = 0; i < joystickCount; i++){
		informationString_ += LampInput::getJoystick(i)->toString() + "\n";
	}
}
//------------------------------------------------------------------------------
// `
void SampleInputJoystick::drawInformation(){
	BasicFramework::drawInformation();
	drawInformationString(informationString_);
	informationString_ = "";
}
//------------------------------------------------------------------------------
