//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXTv XvCg
 * @author Junpee
 */

#include <LampBasic.h>
#include <Framework/System/BasicFramework.h>
#include <Graphics2D/Renderer/SpriteRenderer.h>
#include <Graphics2D/Sprite/Sprite.h>
#include <Graphics2D/SpriteState/Graphics2DSpriteStateAll.h>

// Lamp̃l[Xy[XLɂ
using namespace Lamp;

//------------------------------------------------------------------------------
// NX`Bʏ̓wb_t@CɊi[
//------------------------------------------------------------------------------
/**
 * OtBbNXTv XvCg
 */
class SampleGraphicsSprite : public BasicFramework{
public:
	/**
	 * RXgN^
	 */
	SampleGraphicsSprite(const String& command) :
	  BasicFramework("SampleGraphicsSprite"), command_(command){}

	/**
	 * 
	 * @return ɐtrueԂ
	 */
	virtual bool initialize();

	/**
	 * n
	 */
	virtual void finalize();

	/**
	 * s
	 */
	virtual void run();

	/**
	 * _O
	 */
	virtual void renderSetup();

	/**
	 * _O
	 */
	virtual void render();

	/**
	 * `
	 */
	virtual void drawInformation();

private:
	// R}h
	String command_;
	// 񕶎
	String informationString_;
	// XvCg_
	SpriteRenderer* spriteRenderer_;
	// XvCg0
	Sprite* sprite0_;
	// XvCg1
	Sprite* sprite1_;
};
//------------------------------------------------------------------------------
// vOGg|Cg
//------------------------------------------------------------------------------
// C֐
int WINAPI WinMain(
	HINSTANCE instance, HINSTANCE previousInstance, LPSTR command, int show){
	SampleGraphicsSprite sample(command);
	return sample.execute(instance);
}
//------------------------------------------------------------------------------
// NX
//------------------------------------------------------------------------------
// 
bool SampleGraphicsSprite::initialize(){
backGroundColor_.set(255, 0, 0, 0);
	// _
	spriteRenderer_ = new SpriteRenderer();

	// XvCg0
	sprite0_ = new Sprite();
	sprite0_->setRectangle(100.f, 100.f, 640.f, 640.f);
	sprite0_->setImageRectangle(0.f, 0.f, 1.f, 1.f);
	sprite0_->loadPicture("testRGBA.tga");
	sprite0_->setFit(Sprite::fitScreenHeight);
	sprite0_->setAlign(Sprite::alignBottomRight);

	// XvCg1
	sprite1_ = new Sprite();
	sprite1_->setRectangle(250.f, 250.f, 64.f, 64.f);
	sprite1_->setImageRectangle(-0.5f, -0.5f, 2.f, 2.f);
	sprite1_->loadPicture("testRGBA.tga");

	return true;
}
//------------------------------------------------------------------------------
// n
void SampleGraphicsSprite::finalize(){
	SafeDelete(sprite1_);
	SafeDelete(sprite0_);
	SafeDelete(spriteRenderer_);
}
//------------------------------------------------------------------------------
// s
void SampleGraphicsSprite::run(){
}
//------------------------------------------------------------------------------
// _O
void SampleGraphicsSprite::renderSetup(){
	spriteRenderer_->request(sprite0_);
	spriteRenderer_->request(sprite1_);
}
//------------------------------------------------------------------------------
// _O
void SampleGraphicsSprite::render(){
	spriteRenderer_->render();
}
//------------------------------------------------------------------------------
// `
void SampleGraphicsSprite::drawInformation(){
	BasicFramework::drawInformation();
	drawInformationString(informationString_);
	informationString_ = "";
}
//------------------------------------------------------------------------------
