//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * LampUnit̑SeXgs
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Test/LampUnitTest.h"
#include <Core/Utility/Timer.h>

int _tmain(int argc, _TCHAR* argv[]){
	// Lamp
	LampCore::initialize();
	{
		Timer::Tick startTime = Timer::getTick();
		// eXg
		TestStringListener listener;
		TestResult result;
		result.addListener(&listener);
		LampUnitTest allTest;
		// eXgs
		listener.print("------------------------------"
			"-------------------------------------------------\n");
		listener.printFormat(
			"eXgJn  eXg %d\n", allTest.getCountTestCases());
		allTest.run(&result);
		// ԕ\
		float time = Timer::getInterval(startTime);
		listener.printFormat("\neXgI %.3fms  %d / %d (s / s)\n",
			time, result.getFailureCount(), result.getRunCount());
		if(result.wasSuccessful()){
			listener.print("eXg͖I܂B\n");
		}else{
			listener.print("##############################"
				"#################################################\n");
			listener.print("eXg͎s܂B\n");
		}
		listener.print("------------------------------"
			"-------------------------------------------------\n");
	}
	// Lampn
	LampCore::finalize();
	return 0;
}

