//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eXgXB[geXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "LampUnit/TestSuiteTest.h"
#include "LampUnit/TestCaseTest.h"


//------------------------------------------------------------------------------
// eXgs
void TestSuiteTest::runTest(){
	TestSuite suite("TestSuite");
	TestEquals(0,suite.getCountTestCases());
	suite.addTest(new TestCaseTest::SuccessTestCase());
	suite.addTest(new TestCaseTest::FailureTestCase());
	suite.addTest(new TestCaseTest::FailureMessageTestCase());
	suite.addTest(new TestCaseTest::SetUpFailureTestCase());
	suite.addTest(new TestCaseTest::TearDownFailureTestCase());
	TestEquals(5, suite.getCountTestCases());
	TestEquals("TestSuite", suite.getName());
	TestEquals("Suite TestSuite", suite.toString());

	TestResult result;
	suite.run(&result);
	TestEquals(5, result.getRunCount());
	TestEquals(4, result.getFailureCount());
	TestAssert(!result.wasSuccessful());
}
//------------------------------------------------------------------------------
