//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eXgP[XeXgwb_
 * @author Junpee
 */

#ifndef TEST_CASE_TEST_H_
#define TEST_CASE_TEST_H_

#include <LampUnit/TestCase.h>

//------------------------------------------------------------------------------
/**
 * eXgP[XeXg
 */
class TestCaseTest : public TestCase{
public:
	/**
	 * RXgN^
	 * @param name eXg̖O
	 */
	explicit TestCaseTest(String name) : TestCase(name){}

	/**
	 * eXgs
	 */
	virtual void runTest(){}

	/**
	 * eXgXB[g̎擾
	 * @return eXgXB[g
	 */
	static Test* suite();

	// eXgP[XeXg
	void testCaseTest();

	// AT[geXg
	void testAssert();

	// AT[gCR[eXg
	void testAssertEquals();

	// AT[gmbgCR[eXg
	void testAssertNotEquals();

	// eXgP[X
	class SuccessTestCase : public TestCase {
	public:
		// RXgN^
		explicit SuccessTestCase() : TestCase("SuccessTestCase"){}
		// eXg
		virtual void runTest(){ TestAssert(true); }
	};

	// seXgP[X
	class FailureTestCase : public TestCase {
	public:
		// RXgN^
		explicit FailureTestCase() : TestCase("FailureTestCase"){}
		// eXg
		virtual void runTest(){ TestAssert(false); }
	};

	// s郁bZ[WeXgP[X
	class FailureMessageTestCase : public TestCase {
	public:
		// RXgN^
		explicit FailureMessageTestCase() :
			TestCase("FailureMessageTestCase"){}
		// eXg
		virtual void runTest(){ TestAssertMessage(false, "Failure"); }
	};

	// ZbgAbvŎseXgP[X
	class SetUpFailureTestCase : public TestCase {
	public:
		// RXgN^
		explicit SetUpFailureTestCase() : TestCase("SetUpFailureTestCase"){}
		// ZbgAbv
		virtual void setUp(){ TestAssert(false); }
		// eXg
		virtual void runTest(){}
	};

	// eBA[_EŎseXgP[X
	class TearDownFailureTestCase : public TestCase {
	public:
		// RXgN^
		explicit TearDownFailureTestCase() :
			TestCase("TearDownFailureTestCase"){}
		// eXg
		virtual void runTest(){}
		// eBA[_E
		virtual void tearDown(){ TestAssert(false); }
	};

private:

};

//------------------------------------------------------------------------------
#endif // End of TEST_CASE_TEST_H_
//------------------------------------------------------------------------------
