//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eXgP[XeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "LampUnit/TestCaseTest.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* TestCaseTest::suite(){
	TestSuite* suite = new TestSuite("TestCaseTest");
	suite->addTest(new TestCaller(TestCaseTest, testCaseTest));
	suite->addTest(new TestCaller(TestCaseTest, testAssert));
	suite->addTest(new TestCaller(TestCaseTest, testAssertEquals));
	suite->addTest(new TestCaller(TestCaseTest, testAssertNotEquals));
	return suite;
}
//------------------------------------------------------------------------------
// eXgP[XeXg
void TestCaseTest::testCaseTest(){
	TestEquals(1, this->getCountTestCases());
	TestEquals("TestCaseTest::testCaseTest", this->getName());
	TestEquals("TestCaseTest::testCaseTest", this->toString());
}
//------------------------------------------------------------------------------
// AT[geXg
void TestCaseTest::testAssert(){
	TestAssert(true);
	TestAssertMessage(true, "Hoge");
}
//------------------------------------------------------------------------------
// AT[gCR[eXg
void TestCaseTest::testAssertEquals(){
	TestEquals(1, 1);
	TestEpsilonEquals(0.f, -1.0f, 1.f);
	TestEpsilonEquals(0., -1.0, 1.);
	TestEquals("abc", "abc");
}
//------------------------------------------------------------------------------
// AT[gmbgCR[eXg
void TestCaseTest::testAssertNotEquals(){
	TestNotEquals(1, -1);
	TestNotEpsilonEquals(0.f, -1.0f, 0.5f);
	TestNotEpsilonEquals(0., -1.0, 0.5);
	TestNotEquals("abc", "abcd");
}
//------------------------------------------------------------------------------
