//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eXgR[eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "LampUnit/TestCallerTest.h"
#include "LampUnit/TestCaseTest.h"

//------------------------------------------------------------------------------
// eXgs
void TestCallerTest::runTest(){
	Test* test = new TestCaller(TestCaseTest, testCaseTest);
	TestEquals(1, test->getCountTestCases());
	TestEquals("TestCaseTest::testCaseTest", test->getName());
	TestEquals("TestCaseTest::testCaseTest", test->toString());

	TestResult result;
	test->run(&result);
	TestEquals(1, result.getRunCount());
	TestEquals(0, result.getFailureCount());
	TestAssert(result.wasSuccessful());
	delete test;
}
//------------------------------------------------------------------------------
