//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eXgXB[g
 * @author Junpee
 */

#include <LampBasic.h>
#include "LampUnit/TestSuite.h"
#include "LampUnit/TestResult.h"

namespace LampUnit{

//------------------------------------------------------------------------------
// RXgN^
TestSuite::TestSuite(Lamp::String name) :
	name_(name), string_("Suite " + name_){
}
//------------------------------------------------------------------------------
// fXgN^
TestSuite::~TestSuite(){
	int count = tests_.getCount();
	for(int i = 0; i < count; i++){ delete tests_[i]; }
	tests_.clear();
}
//------------------------------------------------------------------------------
// eXg̒ǉ
void TestSuite::addTest(Test* test){
	tests_.add(test);
}
//------------------------------------------------------------------------------
// eXgs
void TestSuite::run(TestResult* result){
	int count = tests_.getCount();
	for(int i = 0; i < count; i++){
		if(result->shouldStop()){ break; }
		tests_[i]->run(result);
	}
}
//------------------------------------------------------------------------------
// eXgP[X̌擾
int TestSuite::getCountTestCases() const{
	int testCount = 0;
	int count = tests_.getCount();
	for(int i = 0; i < count; i++){
		testCount += tests_[i]->getCountTestCases();
	}
	return testCount;
}
//------------------------------------------------------------------------------
} // End of namespace LampUnit
//------------------------------------------------------------------------------
