//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * fobOo̓Xi
 * @author Junpee
 */

#include <LampBasic.h>
#include "Core/System/StringMethod.h"
#include "LampUnit/TestStringListener.h"
#include "LampUnit/TestFailure.h"
#include "Core/Debug/Logger.h"

namespace LampUnit{

//------------------------------------------------------------------------------
// RXgN^
TestStringListener::TestStringListener(const char* fileName){
	testCount_ = 0;
	if(fileName != NULL){ logger_ = new Lamp::Logger(fileName); }
	else{ logger_ = NULL; }
	
}
//------------------------------------------------------------------------------
// fXgN^
TestStringListener::~TestStringListener(){
	SafeDelete(logger_);
}
//------------------------------------------------------------------------------
// eXgJn
void TestStringListener::startTest(Test* test){
	print(".");	
	testCount_++;
	if((testCount_ % 80) == 0){ print("\n"); }
}
//------------------------------------------------------------------------------
// s̒ǉ
void TestStringListener::addFailure(const TestFailure& failure){
	print("\n");
	printFormat("%s\n", failure.toString());
}
//------------------------------------------------------------------------------
// eXgI
void TestStringListener::endTest(Test* test){
}
//------------------------------------------------------------------------------
// o
void TestStringListener::print(const char* string){
	StdOutputDebugString(string);
	StdPrintf(string);
	// ōDxŃK[֏o
	if(logger_ != NULL){
		logger_->output(Lamp::Logger::fewLevel, string);
	}
}
//------------------------------------------------------------------------------
// tH[}bgo
void TestStringListener::printFormat(const char* format, ...){
	va_list args;
	va_start(args, format);
	char stringBuffer[maxStringLength_];
	int size = StdVsnprintf(stringBuffer,
		sizeof(stringBuffer) - 1, format, args);
	if(size < 0){
		ErrorOut("fobOo͂̃tH[}bgɎs܂B");
	}
	stringBuffer[size] = '\0';
	print(stringBuffer);
	va_end(args);
}
//------------------------------------------------------------------------------
} // End of namespace LampUnit
//------------------------------------------------------------------------------
