//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eXgʎ
 * @author Junpee
 */

#include <LampBasic.h>
#include "LampUnit/TestResult.h"
#include "LampUnit/TestListener.h"

namespace LampUnit{

//------------------------------------------------------------------------------
// RXgN^
TestResult::TestResult(SynchronizationObject* synchronizationObject) :
	SynchronizedObject(synchronizationObject), shouldStop_(false),
	executeCount_(0), failedCount_(0){
}
//------------------------------------------------------------------------------
// eXg̒~
void TestResult::stop(){
	SynchronizedBlock synchronizedBlock(synchronizationObject_);
	shouldStop_ = true;
}
//------------------------------------------------------------------------------
// eXg~ׂ
bool TestResult::shouldStop() const{
	SynchronizedBlock synchronizedBlock(synchronizationObject_);
	return shouldStop_;
}
//------------------------------------------------------------------------------
// eXgXi̒ǉ
void TestResult::addListener(TestListener* testListener){
	SynchronizedBlock synchronizedBlock(synchronizationObject_);
	testListeners_.add(testListener);
}
//------------------------------------------------------------------------------
// eXg̊Jn
void TestResult::startTest(Test *test){
	SynchronizedBlock synchronizedBlock(synchronizationObject_);
	executeCount_++;
	int count = testListeners_.getCount();
	for(int i = 0; i < count; i++){
		testListeners_[i]->startTest(test);
	}
}
//------------------------------------------------------------------------------
// eXg̏I
void TestResult::endTest(Test *test){
	SynchronizedBlock synchronizedBlock(synchronizationObject_);
	int count = testListeners_.getCount();
	for(int i = 0; i < count; i++){
		testListeners_[i]->endTest(test);
	}
}
//------------------------------------------------------------------------------
// s̒ǉ
void TestResult::addFailure(const TestFailure& failure){
	SynchronizedBlock synchronizedBlock(synchronizationObject_);
	failedCount_++;
	int count = testListeners_.getCount();
	for(int i = 0; i < count; i++){
		testListeners_[i]->addFailure(failure);
	}
}
//------------------------------------------------------------------------------
// sJEg̎擾
int TestResult::getRunCount() const{
	SynchronizedBlock synchronizedBlock(synchronizationObject_);
	return executeCount_;
}
//------------------------------------------------------------------------------
// sJEg̎擾
int TestResult::getFailureCount() const{
	SynchronizedBlock synchronizedBlock(synchronizationObject_);
	return failedCount_;
}
//------------------------------------------------------------------------------
/**
 * ǂ
 * @return ĂtrueԂB
 */
bool TestResult::wasSuccessful() const{
	SynchronizedBlock synchronizedBlock(synchronizationObject_);
	return (failedCount_ == 0);
}
//------------------------------------------------------------------------------
} // End of namespace LampUnit
//------------------------------------------------------------------------------
