//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eXgs
 * @author Junpee
 */

#include <sstream>
#include <LampBasic.h>
#include "LampUnit/TestFailure.h"
#include "LampUnit/Test.h"

namespace LampUnit{

//------------------------------------------------------------------------------
// RXgN^
TestFailure::TestFailure(
	Test* failedTest, const Lamp::String& message, const char* file, int line) :
	failedTest_(failedTest), message_(message), file_(file), line_(line){
}
//------------------------------------------------------------------------------
// eXgs𕶎ɕϊ
Lamp::String TestFailure::toString() const{
	Lamp::String result;
	result.format("%s %s [ %s : %d ]",
		failedTest_->toString().getBytes(),
		message_.getBytes(), file_ , line_);
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace LampUnit
//------------------------------------------------------------------------------
