//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eXgP[X
 * @author Junpee
 */

#include <cstdio>
#include <exception>
#include <string>
#include <LampBasic.h>
#include "LampUnit/TestCase.h"
#include "LampUnit/TestResult.h"
#include "LampUnit/TestFailure.h"

namespace LampUnit{

//------------------------------------------------------------------------------
// RXgN^
TestCase::TestCase(Lamp::String name) : name_(name), result_(NULL){
}
//------------------------------------------------------------------------------
// RXgN^
TestCase::TestCase() : name_(""), result_(NULL){
}
//------------------------------------------------------------------------------
// eXgs
void TestCase::run(TestResult* result){
	result_ = result;
	result_->startTest(this);

	try{
		// eXg̃ZbgAbv
		setUp();

		// eXg̎s
		try{
			runTest();
		}catch(std::exception& exception){
			TestFail(exception.what());
		}catch(...){
			TestFail("runTest() catchĂȂO܂B");
		}

		// eXǧn
		try{
			tearDown();
		}catch (...){
			TestFail("tearDown() catchĂȂO܂B");
		}

	}catch(...){
		TestFail("setUp() catchĂȂO܂B");
	}

	result_->endTest(this);
	result_ = NULL;
}
//------------------------------------------------------------------------------
// s̒ǉ
void TestCase::addFailure(
	const Lamp::String& message, const char* file, int line){
	TestFailure failure(this, message, file, line);
	result_->addFailure(failure);
}
//------------------------------------------------------------------------------
// ̔r
bool TestCase::equals(const char* leftValue, const char* rightValue){
	if(leftValue == rightValue){ return true; }
	if((leftValue == NULL) || (rightValue == NULL)){ return false; }
	return (std::strcmp(leftValue, rightValue) == 0);
}
//------------------------------------------------------------------------------
// lłȂbZ[W
Lamp::String TestCase::notEqualMessage(int expected, int actual){
	Lamp::String result;
	result.format(
		"҂l %d łۂ̒l %d łB",
		expected, actual);
	return result;
}
//------------------------------------------------------------------------------
// lłȂbZ[W
Lamp::String TestCase::notEqualMessage(
	u_int expected, u_int actual){
	Lamp::String result;
	result.format(
		"҂l %u łۂ̒l %u łB",
		expected, actual);
	return result;
}
//------------------------------------------------------------------------------
// lłȂbZ[W
Lamp::String TestCase::notEqualMessage(
	float expected, float actual, float epsilon){
	Lamp::String result;
	result.format(
		"҂l %.8f(0x%x) ŁAe덷%.8fł"
		"ۂ̒l %.8f(0x%x) łB",
		expected, *(u_int*)&expected, epsilon, actual, *(u_int*)&actual);
	return result;
}
//------------------------------------------------------------------------------
// lłȂbZ[W
Lamp::String TestCase::notEqualMessage(
	double expected, double actual, double epsilon){
	Lamp::String result;
	result.format(
		"҂l %.16f(0x%I64x) ŁAe덷%.16fł"
		"ۂ̒l %.16f(0x%I64x) łB",
		expected, *(long long*)&expected, epsilon, actual, *(long long*)&actual);
	return result;
}
//------------------------------------------------------------------------------
// 񂪓łȂbZ[W
Lamp::String TestCase::notEqualMessage(const char* expected, const char* actual){
	Lamp::String result("҂镶 ");
	if(expected == NULL){
		result.append("<NULL>");
	}else{
		result.append("\"").append(expected).append("\"");
	}
	result.append(" łۂ̕ ");
	if(actual == NULL){
		result.append("<NULL>");
	}else{
		result.append("\"").append(actual).append("\"");
	}
	result.append(" łB");
	return result;
}
//------------------------------------------------------------------------------
// lbZ[W
Lamp::String TestCase::equalMessage(int notExpected, int actual){
	Lamp::String result;
	result.format(
		"҂Ȃl %d łۂ̒l %d łB",
		notExpected, actual);
	return result;
}
//------------------------------------------------------------------------------
// lbZ[W
Lamp::String TestCase::equalMessage(
	u_int notExpected, u_int actual){
	Lamp::String result;
	result.format(
		"҂Ȃl %u łۂ̒l %u łB",
		notExpected, actual);
	return result;
}
//------------------------------------------------------------------------------
// lbZ[W
Lamp::String TestCase::equalMessage(
	float notExpected, float actual, float epsilon){
	Lamp::String result;
	result.format(
		"҂Ȃl %.8f(0x%x) ŁAe덷%.8fł"
		"ۂ̒l %.8f(0x%x) łB",
		notExpected, *(u_int*)&notExpected, epsilon, actual, *(u_int*)&actual);
	return result;
}
//------------------------------------------------------------------------------
// lbZ[W
Lamp::String TestCase::equalMessage(
	double notExpected, double actual, double epsilon){
	Lamp::String result;
	result.format(
		"҂Ȃl %.16f(0x%I64x) ŁAe덷%.16fł"
		"ۂ̒l %.16f(0x%I64x) łB",
		notExpected, *(long long*)&notExpected, epsilon,
		actual, *(long long*)&actual);
	return result;
}
//------------------------------------------------------------------------------
// 񂪓bZ[W
Lamp::String TestCase::equalMessage(const char* notExpected, const char* actual){
	Lamp::String result("҂Ȃ ");
	if(notExpected == NULL){
		result.append("<NULL>");
	}else{
		result.append("\"").append(notExpected).append("\"");
	}
	result.append(" łۂ̕ ");
	if(actual == NULL){
		result.append("<NULL>");
	}else{
		result.append("\"").append(actual).append("\"");
	}
	result.append(" łB");
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace LampUnit
//------------------------------------------------------------------------------
