//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eXgʃwb_
 * @author Junpee
 */

#ifndef TEST_RESULT_H_
#define TEST_RESULT_H_

#include <LampUnit/SynchronizedObject.h>
#include <Core/Container/ArrayList.h>

namespace LampUnit{

class Test;
class TestListener;
class TestFailure;

//------------------------------------------------------------------------------
/**
 * eXg
 */
class TestResult : protected SynchronizedObject{
public:
	/**
	 * RXgN^
	 * @param synchronizationObject VNiC[[VIuWFNg
	 */
	TestResult(SynchronizationObject* synchronizationObject = 0);

	/// fXgN^
	virtual ~TestResult(){}

	/**
	 * eXg̊Jn
	 * @param test JneXg
	 */
	virtual void startTest(Test *test);

	/**
	 * eXg̏I
	 * @param test IeXg
	 */
	virtual void endTest(Test *test);

	/**
	 * s̒ǉ
	 * @param failure ǉ鎸s
	 */
	virtual void addFailure(const TestFailure& failure);

	/**
	 * eXgXi̒ǉ
	 * @param testListener ǉeXgXi
	 */
	virtual void addListener(TestListener* testListener);

	/**
	 * eXg̒~
	 */
	virtual void stop();

	/**
	 * eXg~ׂ
	 * @retval true eXg~
	 * @retval false eXg~Ȃ
	 */
	virtual bool shouldStop() const;

	/**
	 * sJEg̎擾
	 * @return sJEg
	 */
	virtual int getRunCount() const;

	/**
	 * sJEg̎擾
	 * @return sJEg
	 */
	virtual int getFailureCount() const;

	/**
	 * ǂ
	 * @return ĂtrueԂB
	 */
	virtual bool wasSuccessful() const;

protected:
	/// eXgXiz^
	typedef Lamp::ArrayList<TestListener*> TestListeners;
	/// eXgXiz
	TestListeners testListeners_;
	/// ~tO
	bool shouldStop_;
	/// s
	int executeCount_;
	/// s
	int failedCount_;

private:
	// Rs[RXgN^̉B
	TestResult(const TestResult& copy);

	// Rs[̉B
	void operator =(const TestResult& copy);

};

//------------------------------------------------------------------------------
} // End of namespace LampUnit
#endif // End of TEST_RESULT_H_
//------------------------------------------------------------------------------
