//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eXgswb_
 * @author Junpee
 */

#ifndef TEST_FAILURE_H_
#define TEST_FAILURE_H_

namespace LampUnit{

class Test;

//------------------------------------------------------------------------------
/**
 * eXgs
 */
class TestFailure{
public:
	/**
	 * RXgN^
	 * @param failedTest seXg
	 * @param message bZ[W
	 * @param file t@C
	 * @param line s
	 */
	TestFailure(Test* failedTest, const Lamp::String& message,
		const char* file, int line);

	/// fXgN^
	virtual ~TestFailure(){}

	/**
	 * seXg̎擾
	 * @return seXg
	 */
	Test* failedTest() const { return failedTest_; }

	/**
	 * seXg̏擾
	 * @return seXg̏
	 */
	const Lamp::String& what() const { return message_; }

	/**
	 * eXgst@C̎擾
	 * @return eXgst@C
	 */
	const char* file() const { return file_; }

	/**
	 * eXgst@Cs̎擾
	 * @return eXgst@Cs
	 */
	int line() const { return line_; }

	/**
	 * eXgs𕶎ɕϊ
	 * @return eXgs̕\L
	 */
	Lamp::String toString() const;

private:
	// Rs[RXgN^̉B
	TestFailure(const TestFailure& copy);

	// Rs[̉B
	void operator =(const TestFailure& copy);

	// seXg
	Test* failedTest_;
	// bZ[W
	Lamp::String message_;
	// t@C
	const char* file_;
	// t@Cs
	int line_;
};

//------------------------------------------------------------------------------
} // End of namespace LampUnit
#endif // End of TEST_FAILURE_H_
//------------------------------------------------------------------------------
