//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eXgP[Xwb_
 * @author Junpee
 */

#ifndef TEST_CASE_H_
#define TEST_CASE_H_

#include <LampUnit/Test.h>

/**
 * eXgps}N
 * @param message bZ[W
 */
#define TestFail(message) \
	{ addFailure((message), __FILE__, __LINE__); }

/**
 * eXgpAT[g}N
 * @param condition falseȂAT[g
 */
#define TestAssert(condition) \
	if(!(condition)){ TestFail((#condition)); }

/**
 * eXgpAT[g}N
 * @param condition falseȂAT[g
 * @param message bZ[W
 */
#define TestAssertMessage(condition, message) \
	if(!(condition)){ TestFail((message)); }

/**
 * eXgpCR[}N
 * @param expected ҂l
 * @param actual ۂ̒l
 */
#define TestEquals(expected, actual) \
	{ assertEquals((expected), (actual), __FILE__, __LINE__); }

/**
 * eXgpmbgCR[}N
 * @param notExpected ҂Ȃl
 * @param actual ۂ̒l
 */
#define TestNotEquals(notExpected, actual) \
	{ assertNotEquals((notExpected), (actual), __FILE__, __LINE__); }

/**
 * eXgpCR[}N
 * @param expected ҂l
 * @param actual ۂ̒l
 * @param epsilon e덷
 */
#define TestEpsilonEquals(expected, actual, epsilon) \
	{ assertEquals((expected), (actual), __FILE__, __LINE__, (epsilon)); }

/**
 * eXgpmbgCR[}N
 * @param notExpected ҂Ȃl
 * @param actual ۂ̒l
 * @param epsilon e덷
 */
#define TestNotEpsilonEquals(notExpected, actual, epsilon) \
	{ assertNotEquals((notExpected), (actual), __FILE__, __LINE__, (epsilon)); }

namespace LampUnit{

//------------------------------------------------------------------------------
/**
 * eXgP[Xwb_
 */
class TestCase : public Test{
public:
	/**
	 * RXgN^
	 * @param name eXg̖O
	 */
	explicit TestCase(Lamp::String name);

	/**
	 * fXgN^
	 */
	virtual ~TestCase(){}

	/**
	 * eXgs
	 */
	virtual void run(TestResult* result);

	/**
	 * eXgP[X̌擾
	 * @return eXgP[X̌
	 */
	virtual int getCountTestCases() const{ return 1; }

	/**
	 * eXg̖O擾
	 * @return eXg̖O
	 */
	virtual const Lamp::String& getName() const{ return name_; }

	/**
	 * eXg𕶎ɕϊ
	 * @return eXg̕\L
	 */
	virtual const Lamp::String& toString() const{ return name_; }

	/**
	 * eXg̏
	 */
	virtual void setUp(){}

	/**
	 * eXǧn
	 */
	virtual void tearDown(){}

	/**
	 * eXgXB[g̎擾
	 *
	 * eeXgNX̃XB[g쐬ꍇ́A`\bh
	 * eeXgNXŐVɍ쐬ĂB
	 * @return eXgXB[g
	 */
	static Test* suite(){ return NULL; }

//------------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 *
	 * TestCallerĂ΂ƂɎgp
	 */
	TestCase();

	/**
	 * eXgs
	 */
	virtual void runTest() = 0;

	/**
	 * s̒ǉ
	 * @param message bZ[W
	 * @param file t@C
	 * @param line s
	 */
	virtual void addFailure(
		const Lamp::String& message, const char* file, int line);

	//--------------------------------------------------------------------------
	// lǂ
	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param expected ҂l
	 * @param actual ۂ̒l
	 * @param file t@C
	 * @param line s
	 * @return lȂtrue
	 */
	bool assertEquals(int expected, int actual, const char* file, int line){
		if(expected == actual){ return true; }
		addFailure(notEqualMessage(expected, actual), file, line);
		return false;
	}

	/**
	 * lǂ
	 * @param expected ҂l
	 * @param actual ۂ̒l
	 * @param file t@C
	 * @param line s
	 * @return lȂtrue
	 */
	bool assertEquals(u_int expected, u_int actual,
		const char* file, int line){
		if(expected == actual){ return true; }
		addFailure(notEqualMessage(expected, actual), file, line);
		return false;
	}

	/**
	 * lǂ
	 * @param expected ҂l
	 * @param actual ۂ̒l
	 * @param file t@C
	 * @param line s
	 * @param epsilon e덷
	 * @return lȂtrue
	 */
	bool assertEquals(float expected, float actual,
		const char* file, int line, float epsilon = 0.f){
		Assert(epsilon >= 0.f);
		if(equals(expected, actual, epsilon)){ return true; }
		addFailure(notEqualMessage(expected, actual, epsilon), file, line);
		return false;
	}

	/**
	 * lǂ
	 * @param expected ҂l
	 * @param actual ۂ̒l
	 * @param file t@C
	 * @param line s
	 * @param epsilon e덷
	 * @return lȂtrue
	 */
	bool assertEquals(double expected, double actual,
		const char* file, int line, double epsilon = 0.f){
		Assert(epsilon >= 0.f);
		if(equals(expected, actual, epsilon)){ return true; }
		addFailure(notEqualMessage(expected, actual, epsilon), file, line);
		return false;
	}

	/**
	 * 񂪓ǂ
	 * @param expected ҂镶
	 * @param actual ۂ̕
	 * @param file t@C
	 * @param line s
	 * @return 񂪓Ȃtrue
	 */
	bool assertEquals(
		const char* expected, const char* actual, const char* file, int line){
		if(equals(expected, actual)){ return true; }
		addFailure(notEqualMessage(expected, actual), file, line);
		return false;
	}

	/**
	 * 񂪓ǂ
	 * @param expected ҂镶
	 * @param actual ۂ̕
	 * @param file t@C
	 * @param line s
	 * @return 񂪓Ȃtrue
	 */
	bool assertEquals(const Lamp::String& expected, const Lamp::String& actual,
		const char* file, int line){
		return assertEquals(
			expected.getBytes(), actual.getBytes(), file, line);
	}

	//--------------------------------------------------------------------------
	// lłȂǂ
	//--------------------------------------------------------------------------
	/**
	 * lłȂǂ
	 * @param notExpected ҂Ȃl
	 * @param actual ۂ̒l
	 * @param file t@C
	 * @param line s
	 * @return lȂtrue
	 */
	bool assertNotEquals(
		int notExpected, int actual, const char* file, int line){
		if(notExpected != actual){ return true; }
		addFailure(equalMessage(notExpected, actual), file, line);
		return false;
	}

	/**
	 * lłȂǂ
	 * @param notExpected ҂Ȃl
	 * @param actual ۂ̒l
	 * @param file t@C
	 * @param line s
	 * @return lȂtrue
	 */
	bool assertNotEquals(u_int notExpected, u_int actual,
		const char* file, int line){
		if(notExpected != actual){ return true; }
		addFailure(equalMessage(notExpected, actual), file, line);
		return false;
	}

	/**
	 * lłȂǂ
	 * @param notExpected ҂Ȃl
	 * @param actual ۂ̒l
	 * @param file t@C
	 * @param line s
	 * @param epsilon e덷
	 * @return lȂtrue
	 */
	bool assertNotEquals(float notExpected, float actual,
		const char* file, int line, float epsilon = 0.f){
		Assert(epsilon >= 0.f);
		if(!equals(notExpected, actual, epsilon)){ return true; }
		addFailure(equalMessage(notExpected, actual, epsilon), file, line);
		return false;
	}

	/**
	 * lłȂǂ
	 * @param notExpected ҂Ȃl
	 * @param actual ۂ̒l
	 * @param file t@C
	 * @param line s
	 * @param epsilon e덷
	 * @return lȂtrue
	 */
	bool assertNotEquals(double notExpected, double actual,
		const char* file, int line, double epsilon = 0.f){
		Assert(epsilon >= 0.f);
		if(!equals(notExpected, actual, epsilon)){ return true; }
		addFailure(equalMessage(notExpected, actual, epsilon), file, line);
		return false;
	}

	/**
	 * 񂪓łȂǂ
	 * @param notExpected ҂Ȃ
	 * @param actual ۂ̕
	 * @param file t@C
	 * @param line s
	 * @return 񂪓Ȃtrue
	 */
	bool assertNotEquals(const char* notExpected, const char* actual,
		const char* file, int line){
		if(!equals(notExpected, actual)){ return true; }
		addFailure(equalMessage(notExpected, actual), file, line);
		return false;
	}

	/**
	 * 񂪓łȂǂ
	 * @param notExpected ҂Ȃ
	 * @param actual ۂ̕
	 * @param file t@C
	 * @param line s
	 * @return 񂪓Ȃtrue
	 */
	bool assertNotEquals(
		const Lamp::String& notExpected, const Lamp::String& actual,
		const char* file, int line){
		return assertNotEquals(
			notExpected.getBytes(), actual.getBytes(), file, line);
	}

	//--------------------------------------------------------------------------
	// l̔r
	//--------------------------------------------------------------------------
	/**
	 * float̔r
	 * @param leftValue ̒l
	 * @param rightValue E̒l
	 * @param epsilon e덷
	 * @return lȂtrue
	 */
	static inline bool equals(
		float leftValue, float rightValue, float epsilon = 0.f){
		if(leftValue == rightValue){ return true; }
		float difference = leftValue - rightValue;
		if(difference < 0.f){ difference = -difference; }
		return (difference <= epsilon);
	}

	/**
	 * double̔r
	 * @param leftValue ̒l
	 * @param rightValue E̒l
	 * @param epsilon e덷
	 * @return lȂtrue
	 */
	static inline bool equals(
		double leftValue, double rightValue, double epsilon = 0.f){
		if(leftValue == rightValue){ return true; }
		double difference = leftValue - rightValue;
		if(difference < 0.f){ difference = -difference; }
		return (difference <= epsilon);
	}

	/**
	 * ̔r
	 * @param leftValue ̒l
	 * @param rightValue E̒l
	 * @return lȂtrue
	 */
	static bool equals(const char* leftValue, const char* rightValue);

	//--------------------------------------------------------------------------
	// lłȂbZ[W
	//--------------------------------------------------------------------------
	/**
	 * lłȂbZ[W
	 * @param expected ҂l
	 * @param actual ۂ̒l
	 * @return 쐬ꂽbZ[W
	 */
	static Lamp::String notEqualMessage(int expected, int actual);

	/**
	 * lłȂbZ[W
	 * @param expected ҂l
	 * @param actual ۂ̒l
	 * @return 쐬ꂽbZ[W
	 */
	static Lamp::String notEqualMessage(
		u_int expected, u_int actual);

	/**
	 * lłȂbZ[W
	 * @param expected ҂l
	 * @param actual ۂ̒l
	 * @param epsilon e덷
	 * @return 쐬ꂽbZ[W
	 */
	static Lamp::String notEqualMessage(
		float expected, float actual, float epsilon);

	/**
	 * lłȂbZ[W
	 * @param expected ҂l
	 * @param actual ۂ̒l
	 * @param epsilon e덷
	 * @return 쐬ꂽbZ[W
	 */
	static Lamp::String notEqualMessage(
		double expected, double actual, double epsilon);

	/**
	 * 񂪓łȂbZ[W
	 * @param expected ҂镶
	 * @param actual ۂ̕
	 * @return 쐬ꂽbZ[W
	 */
	static Lamp::String notEqualMessage(
		const char* expected, const char* actual);

	//--------------------------------------------------------------------------
	// lbZ[W
	//--------------------------------------------------------------------------
	/**
	 * lbZ[W
	 * @param notExpected ҂Ȃl
	 * @param actual ۂ̒l
	 * @return 쐬ꂽbZ[W
	 */
	static Lamp::String equalMessage(int notExpected, int actual);

	/**
	 * lbZ[W
	 * @param notExpected ҂Ȃl
	 * @param actual ۂ̒l
	 * @return 쐬ꂽbZ[W
	 */
	static Lamp::String equalMessage(
		u_int notExpected, u_int actual);

	/**
	 * lbZ[W
	 * @param notExpected ҂Ȃl
	 * @param actual ۂ̒l
	 * @param epsilon e덷
	 * @return 쐬ꂽbZ[W
	 */
	static Lamp::String equalMessage(
		float notExpected, float actual, float epsilon);

	/**
	 * lbZ[W
	 * @param notExpected ҂Ȃl
	 * @param actual ۂ̒l
	 * @param epsilon e덷
	 * @return 쐬ꂽbZ[W
	 */
	static Lamp::String equalMessage(
		double notExpected, double actual, double epsilon);

	/**
	 * 񂪓bZ[W
	 * @param notExpected ҂Ȃ
	 * @param actual ۂ̕
	 * @return 쐬ꂽbZ[W
	 */
	static Lamp::String equalMessage(
		const char* notExpected, const char* actual);

//------------------------------------------------------------------------------
private:
	// Rs[RXgN^̉B
	TestCase(const TestCase& copy);

	// Rs[̉B
	void operator =(const TestCase& copy);

	// O
    const Lamp::String name_;
	// eXg
	TestResult* result_;
};

//------------------------------------------------------------------------------
} // End of namespace LampUnit
#endif // End of TEST_CASE_H_
//------------------------------------------------------------------------------
