//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eXgĂяowb_
 * @author Junpee
 */

#ifndef TEST_CALLER_H_
#define TEST_CALLER_H_

/**
 * eXgĂяo}N
 */
#define TestCaller(Fixture, method) \
	TestCallerImplement<Fixture>(#Fixture "::" #method, &Fixture::method)

namespace LampUnit{

//------------------------------------------------------------------------------
/**
 * eXgĂяo
 */
template <typename Fixture>
class TestCallerImplement : public Fixture{
public:
	/// eXg\bȟ^
	typedef void (Fixture::*TestMethod)();

	/**
	 * RXgN^
	 * @param name eXg
	 * @param method eXg\bh
	 */
	TestCallerImplement(Lamp::String name, TestMethod method) :
		Fixture(name), testMethod_(method){
	}

	/**
	 * fXgN^
	 */
	virtual ~TestCallerImplement(){}

	/**
	 * eXgs
	 */
	virtual void runTest(){
		(this->*testMethod_)();
	}

private:
	// Rs[RXgN^̉B
	TestCallerImplement(const TestCallerImplement& copy);

	// Rs[̉B
	void operator =(const TestCallerImplement& copy);

	// eXg\bh
	TestMethod testMethod_;
};

//------------------------------------------------------------------------------
} // End of namespace LampUnit
#endif // End of TEST_CALLER_H_
//------------------------------------------------------------------------------
