//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eXgwb_
 * @author Junpee
 */

#ifndef TEST_H_
#define TEST_H_

namespace LampUnit{

class TestResult;

//------------------------------------------------------------------------------
/**
 * eXg
 */
class Test{
public:
	/**
	 * fXgN^
	 */
	virtual ~Test(){}

	/**
	 * eXgs
	 * @param result [out] eXg
	 */
	virtual void run(TestResult* result) = 0;

	/**
	 * eXgP[X̌擾
	 * @return eXgP[X̌
	 */
	virtual int getCountTestCases() const = 0;

	/**
	 * eXg̖O擾
	 * @return eXg̖O
	 */
	virtual const Lamp::String& getName() const = 0;

	/**
	 * eXg𕶎ɕϊ
	 * @return eXg̕\L
	 */
	virtual const Lamp::String& toString() const = 0;

private:

};

//------------------------------------------------------------------------------
} // End of namespace LampUnit
#endif // End of TEST_H_
//------------------------------------------------------------------------------
