//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊf}l[W̃eXg
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Model/TranslationModelManagerTest.h"
#include "Translator/Model/TranslationModelManager.h"
#include "Translator/Mesh/TranslationMeshManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* TranslationModelManagerTest::suite(){
	TestSuite* suite = new TestSuite("TranslationModelManagerTest");
	suite->addTest(new TestCaller(TranslationModelManagerTest, testCollectModel));
	return suite;
}
//------------------------------------------------------------------------------
// f̎WeXg
void TranslationModelManagerTest::testCollectModel(){
	MGlobal::executeCommand(
		"file -f -o \"TranslationModelManagerTestCollectModel.mb\"", true, true);
//		"file -f -o \"bone.mb\"", true, true);
	TranslationModelManager* modelManager_ = new TranslationModelManager();
	TranslationMeshManager* meshManager_ = new TranslationMeshManager();
	modelManager_->collectModels(meshManager_);



	meshManager_->clear();
	delete meshManager_;
	modelManager_->clear();
	delete modelManager_;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
