/** @file
 * vRpChwb_
 * @author Junpee
 */

#ifndef STD_AFX_H_
#define STD_AFX_H_

#pragma comment(lib, "Foundation.lib")
#pragma comment(lib, "OpenMaya.lib")

#define REQUIRE_IOSTREAM
#include <maya/MStatus.h>
#include <maya/MObject.h>
#include <maya/MGlobal.h>
#include <maya/MPxCommand.h>

// Lamp{CN[h
#include "LampBasic.h"

// Lamp̃l[Xy[XvWFNgŜɑ΂ėLɂB
using namespace Lamp;

// LampCu̒ǉ
#ifdef _DEBUG
	#pragma comment(lib, "LampDebug.lib")
#else
	#pragma comment(lib, "Lamp.lib")
#endif

// LampUnitwb_
#include <LampUnit/LampUnitAll.h>

// LampUnit̃l[Xy[XvWFNgŜɑ΂ėLɂB
using namespace LampUnit;

// LampUnitCu̒ǉ
#ifdef _DEBUG
	#pragma comment(lib, "LampUnitDebug.lib")
#else
	#pragma comment(lib, "LampUnit.lib")
#endif

/**
 * MayaXe[^X`FbN
 * @param check `FbNXe[^X
 */
#define MayaStatusCheck(check) {\
	MStatus result = (check);\
	if(!result){\
		result.perror(MString("\n< < < ERROR > > >\n") +\
			__FILE__ + " " + __LINE__);\
		MString errorString(MString(__FILE__) + " " + __LINE__ + " : " +\
			result.errorString() + "\n");\
		DebugOut("\n< < < ERROR > > >\n");\
		DebugOut(errorString.asChar());\
	}\
}

/**
 * MayaG[o
 */
#define MayaError(message) {\
	MStatus error(MStatus::kFailure);\
	error.perror(MString("\n< < < ERROR > > >\n") +\
		message + " : " + __FILE__ + " " + __LINE__);\
	MString errorString(MString(message) + " : " +\
		__FILE__ + " " + __LINE__ + " : " + error.errorString() + "\n");\
	DebugOut("\n< < < ERROR > > >\n");\
	DebugOut(errorString.asChar());\
}

//------------------------------------------------------------------------------
#endif // End of STD_AFX_H_
//------------------------------------------------------------------------------
