//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Lamp for Maya Test 
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Test/LampForMayaTest.h"
#include "Test/LampForMayaAllTests.h"
#include <Core/Utility/Timer.h>

namespace LampForMaya{

//------------------------------------------------------------------------------
// s
MStatus LampForMayaTest::doIt(const MArgList& args){
	//--------------------------------------------------------------------------
	// ^C}
	Timer::initialize();
	Timer::Tick startTime = Timer::getTick();

	//--------------------------------------------------------------------------
	// eXg
	TestStringListener listener;
	TestResult result;
	result.addListener(&listener);
	LampForMayaAllTests allTest;
	listener.print("------------------------------"
		"-------------------------------------------------\n");
	listener.printFormat(
		"eXgJn  eXg %d\n", allTest.getCountTestCases());
	allTest.run(&result);
//	MGlobal::executeCommand("file -new", true, true);

	//--------------------------------------------------------------------------
	// ԕ\
	float time = Timer::getInterval(startTime);
	listener.printFormat("\neXgI %.3fms  %d / %d (s / s)\n",
		time, result.getFailureCount(), result.getRunCount());
	MStatus mayaResult;
	if(result.wasSuccessful()){
		listener.print("eXg͖I܂B\n");
		mayaResult = MStatus(MStatus::kSuccess);
	}else{
		listener.print("##############################"
			"#################################################\n");
		listener.print("eXg͎s܂B\n");
		mayaResult = MStatus(MStatus::kFailure);
	}
	listener.print("------------------------------"
		"-------------------------------------------------\n");

	//--------------------------------------------------------------------------
	return mayaResult;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
