//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * MayaDAG[eBeB
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Utility/MayaDAGUtility.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// O̎擾
String MayaDAGUtility::getName(const MObject& node){
	MStatus result;
	MFnDagNode dagNode(node, &result);
	MayaStatusCheck(result);
	return String(dagNode.name().asChar());
}
//------------------------------------------------------------------------------
// O̎擾
String MayaDAGUtility::getName(const MDagPath& dagPath){
	MStatus result;
	MFnDagNode dagNode(dagPath, &result);
	MayaStatusCheck(result);
	return String(dagNode.name().asChar());
}
//------------------------------------------------------------------------------
// tpX̎擾
String MayaDAGUtility::getFullPath(const MObject& node){
	MStatus result;
	MFnDagNode dagNode(node, &result);
	MayaStatusCheck(result);
	return String(dagNode.fullPathName().asChar());
}
//------------------------------------------------------------------------------
// tpX̎擾
String MayaDAGUtility::getFullPath(const MDagPath& dagPath){
	MStatus result;
	MFnDagNode dagNode(dagPath, &result);
	MayaStatusCheck(result);
	return String(dagNode.fullPathName().asChar());
}
//------------------------------------------------------------------------------
// vO̎擾
MPlug MayaDAGUtility::getPlug(const MObject& node, const String& plugName){
	MStatus result;
	MFnDagNode dagNode(node, &result);
	MayaStatusCheck(result);
	MPlug plug = dagNode.findPlug(plugName.getBytes(), &result);
	MayaStatusCheck(result);
	return plug;
}
//------------------------------------------------------------------------------
// vO̎擾
MPlug MayaDAGUtility::getPlug(const MDagPath& dagPath, const String& plugName){
	MStatus result;
	MFnDagNode dagNode(dagPath, &result);
	MayaStatusCheck(result);
	MPlug plug = dagNode.findPlug(plugName.getBytes(), &result);
	MayaStatusCheck(result);
	return plug;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
