//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * MayaAgr[g[eBeBwb_
 * @author Junpee
 */

#ifndef MAYA_ATTRIBUTE_UTILITY_H_
#define MAYA_ATTRIBUTE_UTILITY_H_

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * MayaAgr[g[eBeB
 */
class MayaAttributeUtility{
public:
	//--------------------------------------------------------------------------
	// Agr[g̎擾
	//--------------------------------------------------------------------------
	/**
	 * Agr[g̎擾
	 * @param node Agr[gm[h
	 * @param attributeName Agr[g
	 */
	static MObject getAttribute(
		const MObject& node, const String& attributeName);

	/**
	 * vO̎擾
	 * @param node Agr[gm[h
	 * @param plugName vO
	 */
	static MPlug getPlug(
		const MObject& node, const String& plugName);

	//--------------------------------------------------------------------------
	/**
	 * u[Agr[g̎擾
	 * @param node Agr[gm[h
	 * @param attribute Agr[g
	 */
	static bool getBool(const MObject& node, const MObject& attribute);

	/**
	 * u[Agr[g̎擾
	 * @param node Agr[gm[h
	 * @param attributeName Agr[g
	 */
	static bool getBool(const MObject& node, const String& attributeName);

	//--------------------------------------------------------------------------
	/**
	 * Agr[g̎擾
	 * @param node Agr[gm[h
	 * @param attribute Agr[g
	 */
	static int getInt(const MObject& node, const MObject& attribute);

	/**
	 * Agr[g̎擾
	 * @param node Agr[gm[h
	 * @param attributeName Agr[g
	 */
	static int getInt(const MObject& node, const String& attributeName);

	//--------------------------------------------------------------------------
	/**
	 * Agr[g̎擾
	 * @param node Agr[gm[h
	 * @param attribute Agr[g
	 */
	static float getFloat(const MObject& node, const MObject& attribute);

	/**
	 * Agr[g̎擾
	 * @param node Agr[gm[h
	 * @param attributeName Agr[g
	 */
	static float getFloat(const MObject& node, const String& attributeName);

	//--------------------------------------------------------------------------
	/**
	 * Agr[g̎擾
	 * @param node Agr[gm[h
	 * @param attribute Agr[g
	 */
	static String getString(const MObject& node, const MObject& attribute);

	/**
	 * Agr[g̎擾
	 * @param node Agr[gm[h
	 * @param attributeName Agr[g
	 */
	static String getString(const MObject& node, const String& attributeName);

	//--------------------------------------------------------------------------
	/**
	 * OvfJ[Agr[g̎擾
	 * @param node Agr[gm[h
	 * @param attribute Agr[g
	 */
	static Color3f getColor3f(
		const MObject& node, const MObject& attribute);

	/**
	 * OvfJ[Agr[g̎擾
	 * @param node Agr[gm[h
	 * @param attributeName Agr[g
	 */
	static Color3f getColor3f(
		const MObject& node, const String& attributeName);

	//--------------------------------------------------------------------------
	/**
	 * xNgAgr[g̎擾
	 * @param node Agr[gm[h
	 * @param attribute Agr[g
	 */
	static Vector3 getVector(
		const MObject& node, const MObject& attribute);

	/**
	 * xNgAgr[g̎擾
	 * @param node Agr[gm[h
	 * @param attributeName Agr[g
	 */
	static Vector3 getVector(
		const MObject& node, const String& attributeName);

	//--------------------------------------------------------------------------
	/**
	 * sAgr[g̎擾
	 * @param node Agr[gm[h
	 * @param attribute Agr[g
	 */
	static Matrix44 getMatrix(
		const MObject& node, const MObject& attribute);

	/**
	 * sAgr[g̎擾
	 * @param node Agr[gm[h
	 * @param attributeName Agr[g
	 */
	static Matrix44 getMatrix(
		const MObject& node, const String& attributeName);

	//--------------------------------------------------------------------------

private:
	// RXgN^̉B
	MayaAttributeUtility();

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of MAYA_ATTRIBUTE_UTILITY_H_
//------------------------------------------------------------------------------

