//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * MayaAgr[g[eBeB
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Utility/MayaAttributeUtility.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// Agr[g̎擾
MObject MayaAttributeUtility::getAttribute(
	const MObject& node, const String& attributeName){
	MStatus result;
	MFnDependencyNode dependencyNode(node, &result);
	MayaStatusCheck(result);
	MString attrName(attributeName.getBytes());
	MObject attribute = dependencyNode.attribute(attrName, &result);
	MayaStatusCheck(result);
	return attribute;
}
//------------------------------------------------------------------------------
// vO̎擾
MPlug MayaAttributeUtility::getPlug(
	const MObject& node, const String& plugName){
	MStatus result;
	MFnDependencyNode dependencyNode(node, &result);
	MayaStatusCheck(result);
	MPlug plug = dependencyNode.findPlug(plugName.getBytes(), &result);
	MayaStatusCheck(result);
	return plug;
}
//------------------------------------------------------------------------------
// u[Agr[g̎擾
bool MayaAttributeUtility::getBool(
	const MObject& node, const MObject& attribute){
	bool value;
	MPlug plug(node, attribute);
	MayaStatusCheck(plug.getValue(value));
	return value;
}
//------------------------------------------------------------------------------
// u[Agr[g̎擾
bool MayaAttributeUtility::getBool(
	const MObject& node, const String& attributeName){
	return getBool(node, getAttribute(node, attributeName));
}
//------------------------------------------------------------------------------
// Agr[g̎擾
int MayaAttributeUtility::getInt(
	const MObject& node, const MObject& attribute){
	int value;
	MPlug plug(node, attribute);
	MayaStatusCheck(plug.getValue(value));
	return value;
}
//------------------------------------------------------------------------------
// Agr[g̎擾
int MayaAttributeUtility::getInt(
	const MObject& node, const String& attributeName){
	return getInt(node, getAttribute(node, attributeName));
}
//------------------------------------------------------------------------------
// Agr[g̎擾
float MayaAttributeUtility::getFloat(
	const MObject& node, const MObject& attribute){
	float value;
	MPlug plug(node, attribute);
	MayaStatusCheck(plug.getValue(value));
	return value;
}
//------------------------------------------------------------------------------
// Agr[g̎擾
float MayaAttributeUtility::getFloat(
	const MObject& node, const String& attributeName){
	return getFloat(node, getAttribute(node, attributeName));
}
//------------------------------------------------------------------------------
// Agr[g̎擾
String MayaAttributeUtility::getString(
	const MObject& node, const MObject& attribute){
	MString value;
	MPlug plug(node, attribute);
	MayaStatusCheck(plug.getValue(value));
	return String(value.asChar());
}
//------------------------------------------------------------------------------
// Agr[g̎擾
String MayaAttributeUtility::getString(
	const MObject& node, const String& attributeName){
	return getString(node, getAttribute(node, attributeName));
}
//------------------------------------------------------------------------------
// OvfJ[Agr[g̎擾
Color3f MayaAttributeUtility::getColor3f(
	const MObject& node, const MObject& attribute){
	MStatus result;
	MPlug plug(node, attribute);
	MObject plugData;
	MayaStatusCheck(plug.getValue(plugData));
	MFnNumericData data(plugData, &result);
	MayaStatusCheck(result);
	Color3f value;
	MayaStatusCheck(data.getData(value.r, value.g, value.b));
	return value;
}
//------------------------------------------------------------------------------
// OvfJ[Agr[g̎擾
Color3f MayaAttributeUtility::getColor3f(
	const MObject& node, const String& attributeName){
	return getColor3f(node, getAttribute(node, attributeName));
}
//------------------------------------------------------------------------------
// xNgAgr[g̎擾
Vector3 MayaAttributeUtility::getVector(
	const MObject& node, const MObject& attribute){
	MStatus result;
	MPlug plug(node, attribute);
	MObject plugData;
	MayaStatusCheck(plug.getValue(plugData));
	MFnNumericData data(plugData, &result);
	MayaStatusCheck(result);
	Vector3 value;
	MayaStatusCheck(data.getData(value.x, value.y, value.z));
	return value;
}
//------------------------------------------------------------------------------
// xNgAgr[g̎擾
Vector3 MayaAttributeUtility::getVector(
	const MObject& node, const String& attributeName){
	return getVector(node, getAttribute(node, attributeName));
}
//------------------------------------------------------------------------------
// sAgr[g̎擾
Matrix44 MayaAttributeUtility::getMatrix(
	const MObject& node, const MObject& attribute){
	MStatus result;
	MPlug plug(node, attribute);
	MObject plugData;
	MayaStatusCheck(plug.getValue(plugData));
	MFnMatrixData data(plugData, &result);
	MayaStatusCheck(result);
	const MMatrix& matrix = data.matrix(&result);
	MayaStatusCheck(result);
	Matrix44 value;
	// ]us
	for(int i = 0; i < 4; i++){
		for(int j = 0; j < 4; j++){ value.m[i][j] = (float)matrix[j][i]; }
	}
	return value;
}
//------------------------------------------------------------------------------
// sAgr[g̎擾
Matrix44 MayaAttributeUtility::getMatrix(
	const MObject& node, const String& attributeName){
	return getMatrix(node, getAttribute(node, attributeName));
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
