//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊeNX`}l[Wwb_
 * @author Junpee
 */

#ifndef TRANSLATION_TEXTURE_MANAGER_H_
#define TRANSLATION_TEXTURE_MANAGER_H_

#include <Core/Container/HashMap.h>
#include <Core/Container/ArrayList.h>
#include <Translator/Texture/TranslationTexture.h>

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * ϊeNX`}l[W
 */
class TranslationTextureManager{
public:
	/**
	 * RXgN^
	 */
	TranslationTextureManager();

	/**
	 * fXgN^
	 */
	virtual ~TranslationTextureManager();

	/**
	 * eNX`̎W
	 * @return true
	 */
	virtual bool collectTextures();

	/**
	 * Lampւ̕ϊ
	 * @param scene ϊV[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene) const;

	/**
	 * NA
	 * @return 폜IuWFNg
	 */
	virtual int clear();

	/**
	 * eNX`̎擾
	 * @return eNX`
	 */
	virtual int getCount() const{ return array_.getCount(); }

	/**
	 * eNX`̎擾
	 * @param index eNX`̃CfNX
	 * @return eNX`
	 */
	virtual TranslationTexture* get(int index) const{
		return array_.get(index);
	}

	/**
	 * eNX`̌
	 * @param name eNX`
	 * @return eNX`
	 */
	virtual TranslationTexture* search(String name) const{
		return database_.get(name);
	}

protected:
	/**
	 * eNX`̉
	 * @param textureObject eNX`IuWFNg
	 */
	virtual bool analysisTexture(const MObject& textureObject);

private:
	// Rs[RXgN^̉B
	TranslationTextureManager(const TranslationTextureManager& copy);

	// Rs[̉B
	void operator =(const TranslationTextureManager& copy);

	// eNX`f[^x[X
	Lamp::HashMap<String, TranslationTexture*> database_;
	// eNX`z
	ArrayList<TranslationTexture*> array_;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_TEXTURE_MANAGER_H_
//------------------------------------------------------------------------------
