//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊeNX`}l[W
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Texture/TranslationTextureManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationTextureManager::TranslationTextureManager() :
	database_(256, 0.75f), array_(256){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationTextureManager::~TranslationTextureManager(){
	Assert(database_.getCount() == 0);
	Assert(array_.getCount() == 0);
	if(getCount() != 0){ clear(); }
}
//------------------------------------------------------------------------------
// eNX`̎W
bool TranslationTextureManager::collectTextures(){
	MStatus result;
	MItDependencyNodes dependencyNodeIterator(MFn::kFileTexture, &result);
	MayaStatusCheck(result);
	for( ; !dependencyNodeIterator.isDone(); dependencyNodeIterator.next()){
		MObject textureObject = dependencyNodeIterator.item(&result);
		MayaStatusCheck(result);
		if(!analysisTexture(textureObject)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// eNX`̉
bool TranslationTextureManager::analysisTexture(const MObject& textureObject){
	MStatus result;
	MFnDependencyNode textureNode(textureObject, &result);
	MayaStatusCheck(result);
	String textureName = textureNode.name(&result).asChar();
	MayaStatusCheck(result);
	// Ȍd`FbN
	TranslationTexture* exist = database_.get(textureName);
	if(exist != NULL){
		MayaErrorOut(String("TranslationTextureManager::analysisTexture() "
			"OdĂ܂ ") + textureName);
		return false;
	}
	TranslationTexture* texture =
		new TranslationTexture(textureObject, textureName);
	if(!texture->analyze()){
		delete texture;
		return false;
	}
	database_.put(textureName, texture);
	array_.add(texture);
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationTextureManager::convertToLamp(Scene* scene) const{
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->convertToLamp(scene)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// NA
int TranslationTextureManager::clear(){
	int result = getCount();
	// vf̍폜
	for(int i = 0; i < result; i++){ delete array_.get(i); }
	array_.clear();
	database_.clear();
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
