//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊeNX`wb_
 * @author Junpee
 */

#ifndef TRANSLATION_TEXTURE_H_
#define TRANSLATION_TEXTURE_H_

namespace Lamp{
	class Scene;
}

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * ϊeNX`
 */
class TranslationTexture{
friend class TranslationTextureManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationTexture();

	/**
	 * 
	 * @return true
	 */
	virtual bool analyze();

	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene);

	/**
	 * sN`pX̎擾
	 * @return sN`pX
	 */
	virtual String getPicturePath() const{ return picturePath_; }

	/**
	 * sN`̎擾
	 * @return sN`
	 */
	virtual String getPictureName() const{ return pictureName_; }

private:
	/**
	 * RXgN^
	 * @param initializeObject IuWFNg
	 * @param initializeName 閼O
	 */
	TranslationTexture(
		const MObject& initializeObject, const String& initializeName);

	// Rs[RXgN^̉B
	TranslationTexture(const TranslationTexture& copy);

	// Rs[̉B
	void operator =(const TranslationTexture& copy);

	// IuWFNg
	MObject object_;
	// O
	String name_;
	// sN`pX
	String picturePath_;
	// sN`
	String pictureName_;
	// ~[U
	bool mirrorU_;
	// ~[V
	bool mirrorV_;
	// bvU
	bool wrapU_;
	// bvV
	bool wrapV_;
	// s[gUV
	TexCoord2 repeatUV_;
	// ItZbgUV
	TexCoord2 offsetUV_;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_TEXTURE_H_
//------------------------------------------------------------------------------

