//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊeNX`
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Texture/TranslationTexture.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Texture/TextureManager.h"
#include "Graphics/Picture/PictureManager.h"
#include "Core/InputOutput/FilePath.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationTexture::TranslationTexture(
	const MObject& initializeObject, const String& initializeName) :
	object_(initializeObject), name_(initializeName){
}
//------------------------------------------------------------------------------
// 
bool TranslationTexture::analyze(){
	// sN`pX̎擾
	picturePath_ = MayaAttributeUtility::getString(object_, "fileTextureName");
	if(picturePath_.equals("")){
		MayaErrorOut(String("TranslationTexture::analyze() "
			"sN`t@Cݒ肳Ă܂B ") + name_);
		return false;
	}
	// sN`̎擾
	FilePath filePath(picturePath_);
	pictureName_ = filePath.getName();
	// .tgâ݋
	if(filePath.getExtension() != "tga"){
		MayaErrorOut(String("TranslationTexture::analyze() "
			"Targa(.tga)ȊÕsN`tH[}bg͖Ήł ") +
			name_ + " " + picturePath_);
		return false;
	}
	// ~[UVtO̎擾
	mirrorU_ = MayaAttributeUtility::getBool(object_, "mirrorU");
	mirrorV_ = MayaAttributeUtility::getBool(object_, "mirrorV");
	// bvUVtO̎擾
	wrapU_ = MayaAttributeUtility::getBool(object_, "wrapU");
	wrapV_ = MayaAttributeUtility::getBool(object_, "wrapV");
	// s[gUV̎擾
	repeatUV_.u = MayaAttributeUtility::getFloat(object_, "repeatU");
	repeatUV_.v = MayaAttributeUtility::getFloat(object_, "repeatV");
	// ItZbgUV̎擾
	offsetUV_.u = MayaAttributeUtility::getFloat(object_, "offsetU");
	offsetUV_.v = MayaAttributeUtility::getFloat(object_, "offsetV");
	return true;
}
//------------------------------------------------------------------------------
// fXgN^
TranslationTexture::~TranslationTexture(){
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationTexture::convertToLamp(Scene* scene){
	TextureManager* textureManager = scene->getTextureManager();
	SurfaceTexture* texture = textureManager->createSurfaceTexture(name_);
	if(mirrorU_){
		texture->setAddressModeU(Texture::addressModeMirror);
	}else if(wrapU_){
		texture->setAddressModeU(Texture::addressModeWrap);
	}else{
		texture->setAddressModeU(Texture::addressModeClamp);
	}
	if(mirrorV_){
		texture->setAddressModeV(Texture::addressModeMirror);
	}else if(wrapV_){
		texture->setAddressModeV(Texture::addressModeWrap);
	}else{
		texture->setAddressModeV(Texture::addressModeClamp);
	}
	texture->setRepeatUV(repeatUV_);
	texture->setOffsetUV(offsetUV_);
	// sN`Ƃ̃N
	PictureManager* pictureManager = scene->getPictureManager();
	Picture* picture = pictureManager->search(pictureName_);
	if(picture == NULL){
		MayaErrorOut(String("TranslationTexture::convertToLamp() "
			"sN`܂ ") + pictureName_);
		return false;
	}
	texture->addPicture(picture);
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
