//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊV[m[h}l[Wwb_
 * @author Junpee
 */

#ifndef TRANSLATION_SCENE_NODE_MANAGER_H_
#define TRANSLATION_SCENE_NODE_MANAGER_H_

#include <Core/Container/HashMap.h>
#include <Core/Container/ArrayList.h>
#include <Translator/SceneNode/TranslationSceneNode.h>

namespace LampForMaya{

class TranslationModelManager;

//------------------------------------------------------------------------------
/**
 * ϊV[m[h}l[W
 */
class TranslationSceneNodeManager{
public:
	/**
	 * RXgN^
	 */
	TranslationSceneNodeManager();

	/**
	 * fXgN^
	 */
	virtual ~TranslationSceneNodeManager();

	/**
	 * V[m[h̎W
	 * @return true
	 */
	virtual bool collectSceneNodes();

	/**
	 * s{bg̃RpC
	 * @param modelManager f}l[W
	 * @return true
	 */
	virtual bool compilePivot(TranslationModelManager* modelManager);

	/**
	 * Aj[V̎W
	 * @return true
	 */
	virtual bool collectAnimations();

	/**
	 * Lampւ̕ϊ
	 * @param scene ϊV[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene) const;

	/**
	 * Aj[V̕ϊ
	 * @param animationManager Aj[V}l[W
	 * @param animationSet Aj[VZbg
	 * @return true
	 */
	virtual bool convertAnimation(
		AnimationManager* animationManager, AnimationSet* animationSet);

	/**
	 * NA
	 * @return 폜IuWFNg
	 */
	virtual int clear();

	/**
	 * V[m[h̎擾
	 * @return V[m[h
	 */
	virtual int getCount() const{ return array_.getCount(); }

	/**
	 * V[m[h̎擾
	 * @param index V[m[h̃CfNX
	 * @return V[m[h
	 */
	virtual TranslationSceneNode* get(int index) const{
		return array_.get(index);
	}

	/**
	 * V[m[ȟ
	 * @param name V[m[h
	 * @return V[m[h
	 */
	virtual TranslationSceneNode* search(String name) const{
		return database_.get(name);
	}

	/**
	 * LDagm[h`FbN
	 * @param dagPath DagpX
	 * @return LDagm[hȂtrue
	 */
	static bool checkValidDagNode(const MDagPath& dagPath);

protected:
	/**
	 * V[m[h̉
	 * @param dagPath DAGpX
	 */
	virtual bool analysisSceneNode(MDagPath dagPath);

private:
	// Rs[RXgN^̉B
	TranslationSceneNodeManager(const TranslationSceneNodeManager& copy);

	// Rs[̉B
	void operator =(const TranslationSceneNodeManager& copy);

	// V[m[hf[^x[X
	Lamp::HashMap<String, TranslationSceneNode*> database_;
	// V[m[hz
	ArrayList<TranslationSceneNode*> array_;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_SCENE_NODE_MANAGER_H_
//------------------------------------------------------------------------------
