//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊV[m[h}l[W
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/SceneNode/TranslationSceneNodeManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationSceneNodeManager::TranslationSceneNodeManager() :
	database_(256, 0.75f), array_(256){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationSceneNodeManager::~TranslationSceneNodeManager(){
	Assert(database_.getCount() == 0);
	Assert(array_.getCount() == 0);
	if(getCount() != 0){ clear(); }
}
//------------------------------------------------------------------------------
// V[m[h̎W
bool TranslationSceneNodeManager::collectSceneNodes(){
	MStatus result;
	MItDag dagIterator(MItDag::kBreadthFirst, MFn::kInvalid, &result);
	MayaStatusCheck(result);
	MDagPath dagPath;
	for( ; !dagIterator.isDone(); dagIterator.next()){
		result = dagIterator.getPath(dagPath);
		MayaStatusCheck(result);
		MFnDagNode dagNode(dagPath, &result);
		MayaStatusCheck(result);
		// LDagm[h`FbN
		if(!checkValidDagNode(dagPath)){ continue; }
		// CX^XĂ΃LZ
		u_int instanceNumber = dagPath.instanceNumber(&result);
		MayaStatusCheck(result);
		if(instanceNumber > 0){ continue; }
		// gXtH[t@NVĂȂ΃LZ
		// worldIuWFNg͂
		if(!dagPath.hasFn(MFn::kTransform)){ continue; }
		// O̎擾
		MString dagName = dagNode.name(&result);
		MayaStatusCheck(result);
		// OEhv[ȂLZ
		if(dagName == "groundPlane_transform"){ continue; }
		// V[m[h̉
		if(!analysisSceneNode(dagPath)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// LDagm[h`FbN
bool TranslationSceneNodeManager::checkValidDagNode(const MDagPath& dagPath){
	// DAGm[h̃tB^O
	// ƃX}[gɂ
	MStatus result;
	MFnDagNode dagNode(dagPath, &result);
	MayaStatusCheck(result);
	// ԃIuWFNgȂLZ
	if(dagNode.isIntermediateObject()){ return false; }
	// JȂLZ
	if(dagPath.hasFn(MFn::kCamera)){ return false; }
	// P[^ȂLZ
	if(dagPath.hasFn(MFn::kLocator)){ return false; }
	// bNAbgȂLZ
	if(dagPath.hasFn(MFn::kLookAt)){ return false; }
	// WCgȂLZ
	if(dagPath.hasFn(MFn::kJoint)){ return false; }
	// IKGtFN^ȂLZ
	if(dagPath.hasFn(MFn::kIkEffector)){ return false; }
	// IKnhȂLZ
	if(dagPath.hasFn(MFn::kIkHandle)){ return false; }
	// NURBSt@NVĂ΃LZ
	if(dagPath.hasFn(MFn::kNurbsSurface)){ return false; }
	// NURBSJ[ut@NVĂ΃LZ
	if(dagPath.hasFn(MFn::kNurbsCurve)){ return false; }
	// Subdivt@NVĂ΃LZ
	if(dagPath.hasFn(MFn::kSubdiv)){ return false; }
	// Particlet@NVĂ΃LZ
	if(dagPath.hasFn(MFn::kParticle)){ return false; }
	// eBXȂLZ
	if(dagPath.hasFn(MFn::kLattice)){ return false; }
	// tChȂLZ
	if(dagPath.hasFn(MFn::kFluid)){ return false; }
	// tB[hȂLZ
	if(dagPath.hasFn(MFn::kField)){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// V[m[h̉
bool TranslationSceneNodeManager::analysisSceneNode(MDagPath dagPath){
	MStatus result;
	MFnDagNode dagNode(dagPath, &result);
	MayaStatusCheck(result);
	// Ȍd`FbN
	String sceneNodeName = dagNode.name(&result).asChar();
	MayaStatusCheck(result);
	TranslationSceneNode* exist = database_.get(sceneNodeName);
	if(exist != NULL){
		MayaErrorOut(String("TranslationSceneNodeManager::analysisSceneNode() "
			"OdĂ܂ ") + sceneNodeName);
		return false;
	}
	TranslationSceneNode* sceneNode =
		new TranslationSceneNode(dagPath, sceneNodeName);
	if(!sceneNode->analyze()){
		delete sceneNode;
		return false;
	}
	database_.put(sceneNodeName, sceneNode);
	array_.add(sceneNode);
	return true;
}
//------------------------------------------------------------------------------
// s{bg̃RpC
bool TranslationSceneNodeManager::compilePivot(
	TranslationModelManager* modelManager){
	// s{bg̃RpC
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->compilePivot(this, modelManager)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// Aj[V̎W
bool TranslationSceneNodeManager::collectAnimations(){
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->analyzeAnimation()){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationSceneNodeManager::convertToLamp(Scene* scene) const{
	// V[m[h̃Ro[g
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->convertToLamp(scene)){ return false; }
	}
	// N̐ڑ
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->linkConnect(scene)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// Aj[V̕ϊ
bool TranslationSceneNodeManager::convertAnimation(
	AnimationManager* animationManager, AnimationSet* animationSet){
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->convertAnimation(animationManager, animationSet)){
			return false;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// NA
int TranslationSceneNodeManager::clear(){
	int result = getCount();
	// vf̍폜
	for(int i = 0; i < result; i++){ delete array_.get(i); }
	array_.clear();
	database_.clear();
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
