//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊV[wb_
 * @author Junpee
 */

#ifndef TRANSLATION_SCENE_H_
#define TRANSLATION_SCENE_H_

namespace Lamp{
	class Scene;
	class AnimationManager;
	class AnimationSet;
}

namespace LampForMaya{

class TranslationFog;
class TranslationInstanceManager;
class TranslationCameraManager;
class TranslationLightManager;
class TranslationSceneNodeManager;
class TranslationModelManager;
class TranslationMeshManager;
class TranslationMaterialManager;
class TranslationTextureManager;
class TranslationPictureManager;

//------------------------------------------------------------------------------
/**
 * ϊV[
 */
class TranslationScene{
public:
	/**
	 * RXgN^
	 */
	TranslationScene();

	/**
	 * fXgN^
	 */
	virtual ~TranslationScene();

	/**
	 * ̎W
	 * @return true
	 */
	virtual bool collection();

	/**
	 * Aj[V̎W
	 * @return true
	 */
	virtual bool collectAnimation();

	/**
	 * Lampւ̕ϊ
	 * @param scene ϊV[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene);

	/**
	 * Aj[V̕ϊ
	 * @param animationManager Aj[V}l[W
	 * @param animationSet Aj[VZbg
	 * @return true
	 */
	virtual bool convertAnimation(
		AnimationManager* animationManager, AnimationSet* animationSet);

	/**
	 * NA
	 *
	 * IɃV[̑SIuWFNgj܂
	 * @return 폜IuWFNg
	 */
	virtual int clear();

private:
	// Rs[RXgN^̉B
	TranslationScene(const TranslationScene& copy);

	// Rs[̉B
	void operator =(const TranslationScene& copy);

	// tHO
	TranslationFog* fog_;
	// CX^X}l[W
	TranslationInstanceManager* instanceManager_;
	// J}l[W
	TranslationCameraManager* cameraManager_;
	// Cg}l[W
	TranslationLightManager* lightManager_;
	// V[m[h}l[W
	TranslationSceneNodeManager* sceneNodeManager_;
	// f}l[W
	TranslationModelManager* modelManager_;
	// bV}l[W
	TranslationMeshManager* meshManager_;
	// }eA}l[W
	TranslationMaterialManager* materialManager_;
	// eNX`}l[W
	TranslationTextureManager* textureManager_;
	// sN`}l[W
	TranslationPictureManager* pictureManager_;
};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_SCENE_H_
//------------------------------------------------------------------------------
