//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊV[
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Scene/TranslationScene.h"
#include "Translator/Fog/TranslationFog.h"
#include "Translator/Camera/TranslationCameraManager.h"
#include "Translator/Light/TranslationLightManager.h"
#include "Translator/Instance/TranslationInstanceManager.h"
#include "Translator/SceneNode/TranslationSceneNodeManager.h"
#include "Translator/Model/TranslationModelManager.h"
#include "Translator/Mesh/TranslationMeshManager.h"
#include "Translator/Material/TranslationMaterialManager.h"
#include "Translator/Texture/TranslationTextureManager.h"
#include "Translator/Picture/TranslationPictureManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationScene::TranslationScene(){
	fog_ = new TranslationFog();
	instanceManager_ = new TranslationInstanceManager();
	cameraManager_ = new TranslationCameraManager();
	lightManager_ = new TranslationLightManager();
	sceneNodeManager_ = new TranslationSceneNodeManager();
	modelManager_ = new TranslationModelManager();
	meshManager_ = new TranslationMeshManager();
	materialManager_ = new TranslationMaterialManager();
	textureManager_ = new TranslationTextureManager();
	pictureManager_ = new TranslationPictureManager();
}
//------------------------------------------------------------------------------
// fXgN^
TranslationScene::~TranslationScene(){
	SafeDelete(pictureManager_);
	SafeDelete(textureManager_);
	SafeDelete(materialManager_);
	SafeDelete(meshManager_);
	SafeDelete(modelManager_);
	SafeDelete(sceneNodeManager_);
	SafeDelete(lightManager_);
	SafeDelete(cameraManager_);
	SafeDelete(instanceManager_);
	SafeDelete(fog_);
}
//------------------------------------------------------------------------------
// ̎W
bool TranslationScene::collection(){
	// eNX`̎W
	if(!textureManager_->collectTextures()){ return false; }
	// sN`̎W
	if(!pictureManager_->collectPictures(textureManager_)){ return false; }
	// }eA̎W
	if(!materialManager_->collectMaterials()){ return false; }
	// f̎W
	if(!modelManager_->collectModels(meshManager_)){ return false; }
	// Cg̎W
	if(!lightManager_->collectLights()){ return false; }
	// V[m[h̎W
	if(!sceneNodeManager_->collectSceneNodes()){ return false; }
	// s{bg̃RpC
	if(!sceneNodeManager_->compilePivot(modelManager_)){ return false; }
	// J̎W
	if(!cameraManager_->collectCameras()){ return false; }
	// CX^X̎W
	if(!instanceManager_->collectInstances()){ return false; }
	// tHO̎W
	if(!fog_->analyze()){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// Aj[V̎W
bool TranslationScene::collectAnimation(){
	// J̃Aj[VW
	if(!cameraManager_->collectAnimations()){ return false; }
	// V[m[h̃Aj[VW
	if(!sceneNodeManager_->collectAnimations()){ return false; }
	// V[m[h̃Aj[VW
	if(!modelManager_->collectAnimations()){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationScene::convertToLamp(Scene* scene){
	if(!pictureManager_->convertToLamp(scene)){ return false; }
	if(!textureManager_->convertToLamp(scene)){ return false; }
	if(!materialManager_->convertToLamp(scene)){ return false; }
	if(!meshManager_->convertToLamp(scene)){ return false; }
	if(!modelManager_->convertToLamp(scene)){ return false; }
	if(!lightManager_->convertToLamp(scene)){ return false; }
	if(!sceneNodeManager_->convertToLamp(scene)){ return false; }
	if(!cameraManager_->convertToLamp(scene)){ return false; }
	if(!instanceManager_->convertToLamp(scene)){ return false; }
	if(!fog_->convertToLamp(scene)){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// Aj[V̕ϊ
bool TranslationScene::convertAnimation(
	AnimationManager* animationManager, AnimationSet* animationSet){
	// V[m[hAj[Vϊ
	if(!sceneNodeManager_->convertAnimation(
		animationManager, animationSet)){ return false; }
	// fAj[Vϊ
	if(!modelManager_->convertAnimation(
		animationManager, animationSet)){ return false; }
	// JAj[Vϊ
	if(!cameraManager_->convertAnimation(
		animationManager, animationSet)){ return false; }
	// CX^XAj[Vϊ
	if(!instanceManager_->convertAnimation(
		animationManager, animationSet)){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// NA
int TranslationScene::clear(){
	int result = 0;
	result += pictureManager_->clear();
	result += textureManager_->clear();
	result += materialManager_->clear();
	result += meshManager_->clear();
	result += modelManager_->clear();
	result += sceneNodeManager_->clear();
	result += lightManager_->clear();
	result += cameraManager_->clear();
	result += instanceManager_->clear();
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
