//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊsN`}l[Wwb_
 * @author Junpee
 */

#ifndef TRANSLATION_PICTURE_MANAGER_H_
#define TRANSLATION_PICTURE_MANAGER_H_

#include <Core/Container/HashMap.h>
#include <Core/Container/ArrayList.h>
#include <Translator/Picture/TranslationPicture.h>

namespace LampForMaya{

class TranslationTextureManager;

//------------------------------------------------------------------------------
/**
 * ϊsN`}l[W
 */
class TranslationPictureManager{
public:
	/**
	 * RXgN^
	 */
	TranslationPictureManager();

	/**
	 * fXgN^
	 */
	virtual ~TranslationPictureManager();

	/**
	 * sN`̎W
	 * @return true
	 */
	virtual bool collectPictures(TranslationTextureManager* textureManager);

	/**
	 * Lampւ̕ϊ
	 * @param scene ϊV[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene);

	/**
	 * NA
	 * @return 폜IuWFNg
	 */
	virtual int clear();

	/**
	 * sN`̎擾
	 * @return sN`
	 */
	virtual int getCount(){ return array_.getCount(); }

	/**
	 * sN`̎擾
	 * @param index sN`̃CfNX
	 * @return sN`
	 */
	virtual TranslationPicture* get(int index){ return array_.get(index); }

	/**
	 * sN`̌
	 * @param name sN`
	 * @return sN`
	 */
	virtual TranslationPicture* search(String name){
		return database_.get(name);
	}

private:
	// Rs[RXgN^̉B
	TranslationPictureManager(const TranslationPictureManager& copy);

	// Rs[̉B
	void operator =(const TranslationPictureManager& copy);

	// sN`f[^x[X
	Lamp::HashMap<String, TranslationPicture*> database_;
	// sN`z
	ArrayList<TranslationPicture*> array_;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_PICTURE_MANAGER_H_
//------------------------------------------------------------------------------
