//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊsN`}l[W
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Picture/TranslationPictureManager.h"
#include "Translator/Texture/TranslationTextureManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationPictureManager::TranslationPictureManager() :
	database_(256, 0.75f), array_(256){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationPictureManager::~TranslationPictureManager(){
	Assert(database_.getCount() == 0);
	Assert(array_.getCount() == 0);
	if(getCount() != 0){ clear(); }
}
//------------------------------------------------------------------------------
// sN`̎W
bool TranslationPictureManager::collectPictures(
	TranslationTextureManager* textureManager){
	int textureNum = textureManager->getCount();
	for(int i = 0; i < textureNum; i++){
		TranslationTexture* texture = textureManager->get(i);
		// ȌdΖ
		String pictureName = texture->getPictureName();
		TranslationPicture* exist = search(pictureName);
		if(exist != NULL){ continue; }
		String picturePath = texture->getPicturePath();
		TranslationPicture* picture =
			new TranslationPicture(pictureName, picturePath);
		database_.put(pictureName, picture);
		array_.add(picture);
	}
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationPictureManager::convertToLamp(Scene* scene){
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->convertToLamp(scene)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// NA
int TranslationPictureManager::clear(){
	int result = getCount();
	// vf̍폜
	for(int i = 0; i < result; i++){ delete array_.get(i); }
	array_.clear();
	database_.clear();
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
