//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊsN`
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Picture/TranslationPicture.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Picture/PictureManager.h"
#include "Core/Codec/Tga/TargaLoader.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationPicture::TranslationPicture(const String& initializeName,
	const String& initializePath) :
	name_(initializeName), path_(initializePath){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationPicture::~TranslationPicture(){
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationPicture::convertToLamp(Scene* scene){
	PictureManager* pictureManager = scene->getPictureManager();
	TargaLoader loader(path_);
	if(!loader.loadHeader()){
		MayaErrorOut(String("TranslationPicture::convertToLamp() "
			"sN`̓ǂݍ݂Ɏs܂ ") + path_);
		return false;
	}
	Picture* picture;
	if(loader.hasAlpha()){
		PictureRGBA8* pictureRGBA8 = pictureManager->createPictureRGBA8(name_);
		picture = pictureRGBA8;
		pictureRGBA8->setSize(loader.getSize());
		loader.loadImage(pictureRGBA8->getImageBuffer());
	}else{
		PictureRGB8* pictureRGB8 = pictureManager->createPictureRGB8(name_);
		picture = pictureRGB8;
		pictureRGB8->setSize(loader.getSize());
		loader.loadImage(pictureRGB8->getImageBuffer());
	}
	picture->setPath(path_);
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
