//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊWfwb_
 * @author Junpee
 */

#ifndef TRANSLATION_STANDARD_MODEL_H_
#define TRANSLATION_STANDARD_MODEL_H_

#include <Translator/Model/TranslationModel.h>

namespace LampForMaya{

class TranslationRigidMesh;

//------------------------------------------------------------------------------
/**
 * ϊWf
 */
class TranslationStandardModel : public TranslationModel{
friend class TranslationModelManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationStandardModel();

	/**
	 * Wfǂ
	 * @return WfȂtrue
	 */
	virtual bool isStandardStandardModel() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param meshManager bV}l[W
	 * @return true
	 */
	virtual bool analyze(TranslationMeshManager* meshManager);

	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene);

	//--------------------------------------------------------------------------

protected:
	/**
	 * RXgN^
	 * @param initializeObject IuWFNg
	 * @param initializeName 閼O
	 */
	TranslationStandardModel(
		const MObject& initializeObject, const String& initializeName);

private:
	// Rs[RXgN^̉B
	TranslationStandardModel(const TranslationStandardModel& copy);

	// Rs[̉B
	void operator =(const TranslationStandardModel& copy);

	// ϊbVz
	TranslationRigidMesh** transMeshes_;
};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_STANDARD_MODEL_H_
//------------------------------------------------------------------------------

