//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊWf
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Model/TranslationStandardModel.h"
#include "Translator/Mesh/TranslationMeshManager.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Model/ModelManager.h"
#include "Graphics/Mesh/MeshManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationStandardModel::TranslationStandardModel(
	const MObject& initializeObject, const String& initializeName) :
	TranslationModel(initializeObject, initializeName), transMeshes_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationStandardModel::~TranslationStandardModel(){
	SafeArrayDelete(transMeshes_);
}
//------------------------------------------------------------------------------
// 
bool TranslationStandardModel::analyze(TranslationMeshManager* meshManager){
	// f̕
	if(!analyzeModel()){ return false; }

	MStatus result;
	String errorString;
	MFnMesh fnMesh(object_, &result);
	MayaStatusCheck(result);

	// UVZbg̎擾
	MStringArray uvSetNames;
	MayaStatusCheck(fnMesh.getUVSetNames(uvSetNames));
	int uvSetCount = uvSetNames.length();

	// VF[_̎擾
	MObjectArray shaders;
	MIntArray shaderIndices;
	// ɃCX^Xԍ0Ԃ̃ff[^gp
	result = fnMesh.getConnectedShaders(0, shaders, shaderIndices);
	MayaStatusCheck(result);

	// VF[_蓖ĂĂȂ|S΃G[
	for(u_int i = 0; i < shaderIndices.length(); i++){
		if(shaderIndices[i] == -1){
			MIntArray vertexIndex;
			MayaStatusCheck(fnMesh.getPolygonVertices(i, vertexIndex));
			int vertexCount = vertexIndex.length();
			errorString.format("TranslationStandardModel::analyze() "
				"%sɃVF[_̊蓖ĂꂢȂ|S܂ ",
				name_.getBytes());
			for(int i = 0; i < vertexCount; i++){
				MPoint position;
				MayaStatusCheck(fnMesh.getPoint(vertexIndex[i], position));
				String temp;
				temp.format(" ( %.3f , %.3f , %.3f)",
					position.x, position.y, position.z);
				errorString += temp;
			}
			MayaErrorOut(errorString);
			return false;
		}
	}

	// VF[_̐bVpӂ
	int meshCount = shaders.length();
	int nameCount = 0;
	transMeshes_ = new TranslationRigidMesh*[meshCount];
	for(int i = 0; i < meshCount; i++){
		// d̖O쐬
		String meshName;
		while(true){
			meshName.format("%sM%d", name_.getBytes(), nameCount);
			nameCount++;
			TranslationMesh* exist = meshManager->search(meshName);
			if(exist == NULL){ break; }
		}
		transMeshes_[i] = meshManager->createRigidMesh(meshName);
		// fɃbVǉ
		meshes_.add(transMeshes_[i]);
		// UVZbgݒ肷
		transMeshes_[i]->setUVSetCount(uvSetCount);
		// VF[_ݒ肷
		transMeshes_[i]->setMaterialName(getShaderName(shaders[i]));
	}

	// |SbVɊU
	MItMeshPolygon polygonIterator(object_, &result);
	MayaStatusCheck(result);
	int polygonCount = 0;
	for( ; !polygonIterator.isDone(); polygonIterator.next()){
		int shaderIndex = shaderIndices[polygonCount];
		polygonCount++;
		TranslationRigidMesh* mesh = transMeshes_[shaderIndex];

		// ʒu
		MPointArray positions;
		polygonIterator.getPoints(positions, MSpace::kObject, &result);
		MayaStatusCheck(result);
		bool isSquare = (positions.length() == 4);
		if((positions.length() != 3) && (!isSquare)){
			errorString.format("TranslationStandardModel::analyze() "
				"%sOpAlpȊÕ|S(%dp`)Ă܂\n",
				name_.getBytes(), positions.length());
			for(u_int i = 0; i < positions.length(); i++){
				String temp;
				temp.format(" %d ( %.3f , %.3f , %.3f)",
					i, positions[i].x, positions[i].y, positions[i].z);
				errorString += temp;
			}
			MayaErrorOut(errorString);
			return false;
		}
		mesh->addPosition(Vector3((float)positions[0].x,
			(float)positions[0].y, (float)positions[0].z));
		mesh->addPosition(Vector3((float)positions[1].x,
			(float)positions[1].y, (float)positions[1].z));
		mesh->addPosition(Vector3((float)positions[2].x,
			(float)positions[2].y, (float)positions[2].z));
		if(isSquare){
			mesh->addPosition(Vector3((float)positions[0].x,
				(float)positions[0].y, (float)positions[0].z));
			mesh->addPosition(Vector3((float)positions[2].x,
				(float)positions[2].y, (float)positions[2].z));
			mesh->addPosition(Vector3((float)positions[3].x,
				(float)positions[3].y, (float)positions[3].z));
		}

		// @
		MVectorArray normals;
		result = polygonIterator.getNormals(normals, MSpace::kObject);
		MayaStatusCheck(result);
		mesh->addNormal(Vector3(
			(float)normals[0].x, (float)normals[0].y, (float)normals[0].z));
		mesh->addNormal(Vector3(
			(float)normals[1].x, (float)normals[1].y, (float)normals[1].z));
		mesh->addNormal(Vector3(
			(float)normals[2].x, (float)normals[2].y, (float)normals[2].z));
		if(isSquare){
			mesh->addNormal(Vector3(
				(float)normals[0].x, (float)normals[0].y, (float)normals[0].z));
			mesh->addNormal(Vector3(
				(float)normals[2].x, (float)normals[2].y, (float)normals[2].z));
			mesh->addNormal(Vector3(
				(float)normals[3].x, (float)normals[3].y, (float)normals[3].z));
		}

		// J[
		bool hasColor = polygonIterator.hasColor(&result);
		MayaStatusCheck(result);
		if(hasColor){
			MColorArray colors;
			result = polygonIterator.getColors(colors);
			MayaStatusCheck(result);
			mesh->addColor(Color4f(
				colors[0].r, colors[0].g, colors[0].b, colors[0].a));
			mesh->addColor(Color4f(
				colors[1].r, colors[1].g, colors[1].b, colors[1].a));
			mesh->addColor(Color4f(
				colors[2].r, colors[2].g, colors[2].b, colors[2].a));
			if(isSquare){
				mesh->addColor(Color4f(
					colors[0].r, colors[0].g, colors[0].b, colors[0].a));
				mesh->addColor(Color4f(
					colors[2].r, colors[2].g, colors[2].b, colors[2].a));
				mesh->addColor(Color4f(
					colors[3].r, colors[3].g, colors[3].b, colors[3].a));
			}
		}

		// UV
		MFloatArray uArray, vArray;
		for(int i = 0; i < uvSetCount; i++){
			result = polygonIterator.getUVs(uArray, vArray, &uvSetNames[i]);
			if(!result){
				errorString.format("TranslationStandardModel::analyze "
					"UV̎擾Ɏs܂ %s %s (%.2f, %.2f, %.2f) %s",
					name_.getBytes(), uvSetNames[i].asChar(),
					positions[0].x, positions[0].y, positions[0].z,
					result.errorString().asChar());
				MayaErrorOut(errorString);
				return false;
			}
			// VW𔽓]
			mesh->addUV(TexCoord2(uArray[0], (vArray[0] - 1.f) * -1.f));
			mesh->addUV(TexCoord2(uArray[1], (vArray[1] - 1.f) * -1.f));
			mesh->addUV(TexCoord2(uArray[2], (vArray[2] - 1.f) * -1.f));
		}
		if(isSquare){
			for(int i = 0; i < uvSetCount; i++){
				result = polygonIterator.getUVs(uArray, vArray, &uvSetNames[i]);
				if(!result){
					errorString.format("TranslationStandardModel::analyze "
						"UV̎擾Ɏs܂ %s %s (%.2f, %.2f, %.2f) %s",
						name_.getBytes(), uvSetNames[i].asChar(),
						positions[0].x, positions[0].y, positions[0].z,
						result.errorString().asChar());
					MayaErrorOut(errorString);
					return false;
				}
				// VW𔽓]
				mesh->addUV(TexCoord2(uArray[0], (vArray[0] - 1.f) * -1.f));
				mesh->addUV(TexCoord2(uArray[2], (vArray[2] - 1.f) * -1.f));
				mesh->addUV(TexCoord2(uArray[3], (vArray[3] - 1.f) * -1.f));
			}
		}
	}

	// bV̘_`FbN
	for(int i = 0; i < meshCount; i++){
		if(!transMeshes_[i]->logicalCheck()){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationStandardModel::convertToLamp(Scene* scene){
	ModelManager* modelManager = scene->getModelManager();
	StandardModel* model = modelManager->createStandardModel(name_);
	// LAtO
	model->setEnabled(visibility_);
	// bVƂ̃N
	MeshManager* meshManager = scene->getMeshManager();
	int meshCount = meshes_.getCount();
	for(int i = 0; i < meshCount; i++){
		String meshName = meshes_.get(i)->getName();
		Mesh* mesh = meshManager->search(meshName);
		if(mesh == NULL){
			MayaErrorOut(String("TranslationStandardModel::convertToLamp() "
				"bV܂ ") + meshName);
			return false;
		}
		model->addMesh(mesh);
	}
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
