//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊf}l[Wwb_
 * @author Junpee
 */

#ifndef TRANSLATION_MODEL_MANAGER_H_
#define TRANSLATION_MODEL_MANAGER_H_

#include <Core/Container/HashMap.h>
#include <Core/Container/ArrayList.h>
#include <Translator/Model/TranslationStandardModel.h>

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * ϊf}l[W
 */
class TranslationModelManager{
public:
	/**
	 * RXgN^
	 */
	TranslationModelManager();

	/**
	 * fXgN^
	 */
	virtual ~TranslationModelManager();

	//--------------------------------------------------------------------------
	/**
	 * f̎W
	 * @param meshManager bV}l[W
	 * @return true
	 */
	virtual bool collectModels(TranslationMeshManager* meshManager);

	/**
	 * Aj[V̎W
	 * @return true
	 */
	virtual bool collectAnimations();

	//--------------------------------------------------------------------------
	/**
	 * Lampւ̕ϊ
	 * @param scene ϊV[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene) const;

	/**
	 * Aj[V̕ϊ
	 * @param animationManager Aj[V}l[W
	 * @param animationSet Aj[VZbg
	 * @return true
	 */
	virtual bool convertAnimation(
		AnimationManager* animationManager, AnimationSet* animationSet);

	//--------------------------------------------------------------------------
	/**
	 * NA
	 * @return 폜IuWFNg
	 */
	virtual int clear();

	/**
	 * f̎擾
	 * @return f
	 */
	virtual int getCount() const{ return array_.getCount(); }

	/**
	 * f̎擾
	 * @param index f̃CfNX
	 * @return f
	 */
	virtual TranslationModel* get(int index) const{ return array_.get(index); }

	/**
	 * f̌
	 * @param name 郂f
	 * @return f
	 */
	virtual TranslationModel* search(String name) const{
		return database_.get(name);
	}

protected:
	/**
	 * f̉
	 * @param dagPath DAGpX
	 */
	virtual bool analysisModel(MDagPath dagPath);

private:
	// Rs[RXgN^̉B
	TranslationModelManager(const TranslationModelManager& copy);

	// Rs[̉B
	void operator =(const TranslationModelManager& copy);

	// ff[^x[X
	Lamp::HashMap<String, TranslationModel*> database_;
	// fz
	ArrayList<TranslationModel*> array_;
	// bV}l[W
	TranslationMeshManager* meshManager_;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_MODEL_MANAGER_H_
//------------------------------------------------------------------------------
