//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊf}l[W
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Model/TranslationModelManager.h"
#include "Translator/Model/TranslationCharacterModel.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationModelManager::TranslationModelManager() :
	database_(256, 0.75f), array_(256){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationModelManager::~TranslationModelManager(){
	Assert(database_.getCount() == 0);
	Assert(array_.getCount() == 0);
	if(getCount() != 0){ clear(); }
}
//------------------------------------------------------------------------------
// f̎W
bool TranslationModelManager::collectModels(
	TranslationMeshManager* meshManager){
	meshManager_ = meshManager;
	MStatus result;
	// DDAGCe[^
	MItDag dagIterator(MItDag::kBreadthFirst, MFn::kInvalid, &result);
	MayaStatusCheck(result);
	MDagPath dagPath;
	for( ; !dagIterator.isDone(); dagIterator.next()){
		result = dagIterator.getPath(dagPath);
		MayaStatusCheck(result);
		// f
		if(!analysisModel(dagPath)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// f̉
bool TranslationModelManager::analysisModel(MDagPath dagPath){
	MStatus result;
	MFnDagNode dagNode(dagPath, &result);
	MayaStatusCheck(result);
	// ԃIuWFNgȂLZ
	if(dagNode.isIntermediateObject()){ return true; }
	// bVt@NVĂȂ΃LZ
	if(!dagPath.hasFn(MFn::kMesh)){ return true; }
	// gXtH[t@NVĂ΃LZ
	if(dagPath.hasFn(MFn::kTransform)){ return true; }
	// IuWFNg̎擾
	MObject modelObject = dagPath.node(&result);
	MayaStatusCheck(result);
	// Ȍd`FbN
	String modelName = dagNode.name(&result).asChar();
	MayaStatusCheck(result);
	TranslationModel* exist = database_.get(modelName);
	if(exist != NULL){
		// IuWFNgȂCX^XȂ̂œǂݔ΂AłȂ΃G[
		if(exist->getObject() != modelObject){
			MayaErrorOut(String("TranslationModelManager::analysisModel() "
				"OdĂ܂ ") + modelName);
			return false;
		}
		return true;
	}

	// LN^bV̔
	MPlug inMeshPlug = MayaNodeUtility::getPlug(modelObject, "inMesh");
	// sꍇ̂result̓`FbNȂ
	MItDependencyGraph characterIterator(inMeshPlug,
		MFn::kSkinClusterFilter, MItDependencyGraph::kUpstream,
		MItDependencyGraph::kBreadthFirst,
		MItDependencyGraph::kNodeLevel, &result);
	MObject inMesh = characterIterator.thisNode(&result);
	TranslationModel* model = NULL;
	if((!inMesh.isNull()) && inMesh.hasFn(MFn::kSkinClusterFilter)){
		// XLNX^ȂLN^f
		model = new TranslationCharacterModel(modelObject, modelName, inMesh);
	}else{
		// łȂ΃X^_[hf
		model = new TranslationStandardModel(modelObject, modelName);
	}

	// f̃AiCY
	if(!model->analyze(meshManager_)){
		delete model;
		return false;
	}
	// f[^x[Xɒǉ
	database_.put(modelName, model);
	array_.add(model);
	return true;
}
//------------------------------------------------------------------------------
// Aj[V̎W
bool TranslationModelManager::collectAnimations(){
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->analyzeAnimation()){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationModelManager::convertToLamp(Scene* scene) const{
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->convertToLamp(scene)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// Aj[V̕ϊ
bool TranslationModelManager::convertAnimation(
	AnimationManager* animationManager, AnimationSet* animationSet){
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->convertAnimation(animationManager, animationSet)){
			return false;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// NA
int TranslationModelManager::clear(){
	int result = getCount();
	// vf̍폜
	for(int i = 0; i < result; i++){ delete array_.get(i); }
	array_.clear();
	database_.clear();
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
