//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊfwb_
 * @author Junpee
 */

#ifndef TRANSLATION_MODEL_H_
#define TRANSLATION_MODEL_H_

namespace Lamp{
	class Scene;
	class AnimationManager;
	class AnimationSet;
}

#include <Core/Container/ArrayList.h>

namespace LampForMaya{

class TranslationMeshManager;
class TranslationMesh;
class TranslationStandardModel;
class TranslationCharacterModel;

//------------------------------------------------------------------------------
/**
 * ϊf
 */
class TranslationModel{
friend class TranslationModelManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationModel();

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param meshManager bV}l[W
	 * @return true
	 */
	virtual bool analyze(TranslationMeshManager* meshManager) = 0;

	/**
	 * s{bg̃RpC
	 * @param pivot s{bgʒu
	 */
	virtual void compilePivot(const Vector3& pivot);

	/**
	 * Aj[V̕
	 * @return true
	 */
	virtual bool analyzeAnimation(){ return true; }

	//--------------------------------------------------------------------------
	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene) = 0;

	/**
	 * Aj[V̕ϊ
	 * @param animationManager Aj[V}l[W
	 * @param animationSet Aj[VZbg
	 * @return true
	 */
	virtual bool convertAnimation(
		AnimationManager* animationManager, AnimationSet* animationSet){
		return true;
	}

	//--------------------------------------------------------------------------
	/**
	 * IuWFNg̎擾
	 * @return IuWFNg
	 */
	virtual MObject getObject() const{ return object_; }

	/**
	 * O̎擾
	 * @return O
	 */
	virtual String getName() const{ return name_; }

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * Wfǂ
	 * @return WfȂtrue
	 */
	virtual bool isStandardModel() const{ return false; }

	/**
	 * Wfւ̃LXg
	 * @return WfB^ႦNULLԂB
	 */
	virtual TranslationStandardModel* castStandardModel() const{
		if(isStandardModel()){
			return (TranslationStandardModel*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * LN^fǂ
	 * @return LN^fȂtrue
	 */
	virtual bool isCharacterModel() const{ return false; }

	/**
	 * LN^fւ̃LXg
	 * @return LN^fB^ႦNULLԂB
	 */
	virtual TranslationCharacterModel* castCharacterModel() const{
		if(isCharacterModel()){
			return (TranslationCharacterModel*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------

protected:
	/**
	 * RXgN^
	 * @param initializeObject IuWFNg
	 * @param initializeName 閼O
	 */
	TranslationModel(
		const MObject& initializeObject, const String& initializeName);

	/**
	 * f̉
	 */
	virtual bool analyzeModel();

	/**
	 * VF[_̎擾
	 * @param shadingEngine VF[fBOGW
	 * @return VF[_
	 */
	virtual String getShaderName(const MObject& shadingEngine);

	/// bVz
	ArrayList<TranslationMesh*> meshes_;
	/// IuWFNg
	MObject object_;
	/// O
	String name_;
	/// \tO
	bool visibility_;

private:
	// Rs[RXgN^̉B
	TranslationModel(const TranslationModel& copy);

	// Rs[̉B
	void operator =(const TranslationModel& copy);


};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_MODEL_H_
//------------------------------------------------------------------------------

