//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊf
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Model/TranslationModel.h"
#include "Translator/Mesh/TranslationMesh.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationModel::TranslationModel(
	const MObject& initializeObject, const String& initializeName) :
	object_(initializeObject), name_(initializeName), visibility_(false){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationModel::~TranslationModel(){
}
//------------------------------------------------------------------------------
// s{bg̃RpC
void TranslationModel::compilePivot(const Vector3& pivot){
	int meshCount = meshes_.getCount();
	for(int i = 0; i < meshCount; i++){
		TranslationMesh* mesh = meshes_.get(i);
		mesh->compilePivot(pivot);
	}
}
//------------------------------------------------------------------------------
// f̃AiCY
bool TranslationModel::analyzeModel(){
	visibility_ = MayaAttributeUtility::getBool(object_, "visibility");
	return true;
}
//------------------------------------------------------------------------------
// VF[_̎擾
String TranslationModel::getShaderName(const MObject& shadingEngine){
	MStatus result;
	if(!shadingEngine.hasFn(MFn::kShadingEngine)){
		MayaErrorOut(String("TranslationModel::getShaderName() ") + 
			name_ + "ɃVF[fBOGWڑĂ܂");
		return "";
	}
	// VF[fBOGWT[tF[XVF[_ǂ
	MPlug surfaceShaderPlug = MayaNodeUtility::getPlug(
		shadingEngine, "surfaceShader");
	MPlugArray shaderArray;
	surfaceShaderPlug.connectedTo(shaderArray, true, false, &result);
	MayaStatusCheck(result);
	if(shaderArray.length() == 0){
		MayaErrorOut(String("TranslationStandardModel::analyze() ") + 
			name_ + "ɃT[tF[XVF[_ڑĂ܂");
		return "";
	}
	return MayaNodeUtility::getName(shaderArray[0].node());
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
