//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊLN^fwb_
 * @author Junpee
 */

#ifndef TRANSLATION_CHARACTER_MODEL_H_
#define TRANSLATION_CHARACTER_MODEL_H_

#include <Translator/Model/TranslationModel.h>
#include <Translator/Animation/TranslationSequence.h>

namespace LampForMaya{

class TranslationBone;
class TranslationCharacterMesh;

//------------------------------------------------------------------------------
/**
 * ϊLN^f
 */
class TranslationCharacterModel : public TranslationModel{
friend class TranslationModelManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationCharacterModel();

	/**
	 * LN^fǂ
	 * @return LN^fȂtrue
	 */
	virtual bool isCharacterModel() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param meshManager bV}l[W
	 * @return true
	 */
	virtual bool analyze(TranslationMeshManager* meshManager);

	/**
	 * Aj[V̕
	 * @return true
	 */
	virtual bool analyzeAnimation();

	//--------------------------------------------------------------------------
	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene);

	/**
	 * Aj[V̕ϊ
	 * @param animationManager Aj[V}l[W
	 * @param animationSet Aj[VZbg
	 * @return true
	 */
	virtual bool convertAnimation(
		AnimationManager* animationManager, AnimationSet* animationSet);

	//--------------------------------------------------------------------------
	/**
	 * ϊ{[̌
	 * @param boneName {[
	 * @return {[
	 */
	virtual TranslationBone* searchBone(const String& boneName);

protected:
	/**
	 * RXgN^
	 * @param initializeObject IuWFNg
	 * @param initializeName 閼O
	 * @param skinClusterObject XLNX^IuWFNg
	 */
	TranslationCharacterModel(
		const MObject& initializeObject, const String& initializeName,
		const MObject& skinClusterObject);

	/**
	 * {[̃AiCY
	 * @return true
	 */
	virtual bool analyzeBone();

	/**
	 * bṼAiCY
	 * @param meshManager bV}l[W
	 * @return true
	 */
	virtual bool analyzeMesh(TranslationMeshManager* meshManager);

	/**
	 * EFCg̃AiCY
	 * @return true
	 */
	virtual bool analyzeWeight();

private:
	// Rs[RXgN^̉B
	TranslationCharacterModel(const TranslationCharacterModel& copy);

	// Rs[̉B
	void operator =(const TranslationCharacterModel& copy);

	// XLNX^IuWFNg
	MObject skinClusterObject_;
	// XLNX^
	MFnSkinCluster skinCluster_;
	// ϊ{[z
	TranslationBone* transBones_;
	// ϊ{[
	int transBoneCount_;
	// ϊbV
	int transMeshCount_;
	// ϊbVz
	TranslationCharacterMesh** transMeshes_;

	/// V[PX
	TranslationSequence sequence_;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_CHARACTER_MODEL_H_
//------------------------------------------------------------------------------

