//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊ{[wb_
 * @author Junpee
 */

#ifndef TRANSLATION_BONE_H_
#define TRANSLATION_BONE_H_

#include <Core/Container/ArrayList.h>

namespace Lamp{
	class CharacterModel;
	class VectorArrayInterpolator;
	class EulerArrayInterpolator;
	class VectorInterpolator;
	class RotationInterpolator;
}

namespace LampForMaya{

class TranslationCharacterModel;

//------------------------------------------------------------------------------
/**
 * ϊ{[
 */
class TranslationBone{
friend class TranslationCharacterModel;
protected:

	/**
	 * RXgN^
	 */
	TranslationBone();

	/**
	 * fXgN^
	 */
	virtual ~TranslationBone();

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return true
	 */
	virtual bool analyze(const MDagPath& dagPath);

	/**
	 * fs̍\z
	 * @param characterModel ϊLN^f
	 * @param parentMatrix es
	 */
	virtual void buildModelMatrix(
		TranslationCharacterModel* characterModel, const Matrix34& parentMatrix);

	/**
	 * Aj[V̕
	 * @param startTime Jn
	 * @param endTime I
	 * @return true
	 */
	virtual bool analyzeAnimation(int startTime, int endTime);

	//--------------------------------------------------------------------------
	/**
	 * O̎擾
	 * @return O
	 */
	const String& getName() const{ return name_; }

	/**
	 * |[Yts̎擾
	 * @return |[Yts
	 */
	const Matrix34& getInversePoseMatrix() const{ return inversePoseMatrix_; }

	/**
	 * Lampւ̕ϊ
	 * @param model LN^f
	 * @return true
	 */
	virtual bool convertToLamp(CharacterModel* model);

	/**
	 * {[̃N
	 * @param model LN^f
	 * @param index {[̃CfbNX
	 * @return true
	 */
	virtual bool boneLink(CharacterModel* model, int index);

	/**
	 * XP[Aj[V̎擾
	 * @param startTime Jn
	 * @param endTime I
	 * @return XP[Aj[V
	 */
	virtual VectorInterpolator* getScaleAnimation(int startTime, int endTime);

	/**
	 * ]Aj[V̎擾
	 * @param startTime Jn
	 * @param endTime I
	 * @return ]Aj[V
	 */
	virtual RotationInterpolator* getRotationAnimation(
		int startTime, int endTime);

	/**
	 * ړAj[V̎擾
	 * @param startTime Jn
	 * @param endTime I
	 * @return ړAj[V
	 */
	virtual VectorInterpolator* getTranslationAnimation(
		int startTime, int endTime);

private:
	// Rs[RXgN^̉B
	TranslationBone(const TranslationBone& copy);

	// Rs[̉B
	void operator =(const TranslationBone& copy);

	// |[Ys
	Matrix34 inversePoseMatrix_;
	/// {[Xg
	ArrayList<String> bones_;
	// DagpX
	MDagPath dagPath_;
	// IuWFNg
	MObject object_;
	// O
	String name_;
	// WCg]
	Vector3 jointRotation_;
	// IWi]
	Vector3 originalRotation_;
	// XP[
	Vector3 scale_;
	// ]
	Vector3 rotation_;
	// ړ
	Vector3 translation_;

	/// XP[Aj[V
	VectorArrayInterpolator* scaleAnimation_;
	/// ]Aj[V
	EulerArrayInterpolator* rotationAnimation_;
	/// ړAj[V
	VectorArrayInterpolator* translationAnimation_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TRANSLATION_BONE_H_
//------------------------------------------------------------------------------
