//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊ̃bVwb_
 * @author Junpee
 */

#ifndef TRANSLATION_RIGID_MESH_H_
#define TRANSLATION_RIGID_MESH_H_

#include <Translator/Mesh/TranslationMesh.h>
#include <Core/Container/ArrayList.h>

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * ϊ̃bV
 */
class TranslationRigidMesh : public TranslationMesh{
friend class TranslationMeshManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationRigidMesh();

	/**
	 * ÓĨbVǂ
	 * @return ÓĨbVȂtrue
	 */
	virtual bool isRigidMesh() const{ return true; }

	/**
	 * s{bg̃RpC
	 * @param pivot s{bgʒu
	 */
	virtual void compilePivot(const Vector3& pivot);

	//--------------------------------------------------------------------------
	/**
	 * _`FbN
	 * @return true
	 */
	virtual bool logicalCheck();

	//--------------------------------------------------------------------------
	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene);

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param initializeName 閼O
	 */
	TranslationRigidMesh(const String& initializeName);

private:
	// Rs[RXgN^̉B
	TranslationRigidMesh(const TranslationRigidMesh& copy);

	// Rs[̉B
	void operator =(const TranslationRigidMesh& copy);


};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_RIGID_MESH_H_
//------------------------------------------------------------------------------

