//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊ̃bV
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Mesh/TranslationRigidMesh.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Mesh/MeshManager.h"
#include "Graphics/MeshData/MeshDataManager.h"
#include "Graphics/Material/MaterialManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationRigidMesh::TranslationRigidMesh(const String& initializeName) :
	TranslationMesh(initializeName){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationRigidMesh::~TranslationRigidMesh(){
}
//------------------------------------------------------------------------------
// _`FbN
bool TranslationRigidMesh::logicalCheck(){
	if(!vertexLogicalCheck()){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// s{bg̃RpC
void TranslationRigidMesh::compilePivot(const Vector3& pivot){
	int vertexCount = positions_.getCount();
	for(int i = 0; i < vertexCount; i++){
		Vector3 position = positions_.get(i);
		position -= pivot;
		positions_.set(i, position);
	}
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationRigidMesh::convertToLamp(Scene* scene){
	MeshManager* meshManager = scene->getMeshManager();
	RigidMesh* mesh = meshManager->createRigidMesh(name_);
	// bVf[^
	MeshDataManager* meshDataManager = scene->getMeshDataManager();
	String meshDataName(name_);
	meshDataName.append("d");
	MeshData* meshData = meshDataManager->createMeshData(meshDataName);
	mesh->setMeshData(meshData);
	// ݒ
	mesh->setPrimitiveType(Mesh::triangleList);
	int vertexCount = positions_.getCount();
	mesh->setVertexCount(vertexCount);
	mesh->enableNormal(true);
	for(int i = 0; i < vertexCount; i++){
		mesh->setPosition(i, positions_[i]);
		mesh->setNormal(i, normals_[i]);
	}
	if(colors_.getCount() != 0){
		mesh->enableColor(true);
		for(int i = 0; i < vertexCount; i++){
			Color4c color(colors_[i]);
			mesh->setColor(i, color);
		}
	}
	if(uvs_.getCount() != 0){
		mesh->setTexCoordSetCount(uvSetCount_);
		for(int i = 0; i < uvSetCount_; i++){
			mesh->setTexCoordType(i, TexCoord::type2);
		}
		int uvIndex = 0;
		int polygonCount = vertexCount / 3;
		for(int i = 0; i < polygonCount; i++){
			int vertexOffset = i * 3;
			for(int j = 0; j < uvSetCount_; j++){
				mesh->setTexCoord2(vertexOffset + 0, j, uvs_[uvIndex]);
				uvIndex++;
				mesh->setTexCoord2(vertexOffset + 1, j, uvs_[uvIndex]);
				uvIndex++;
				mesh->setTexCoord2(vertexOffset + 2, j, uvs_[uvIndex]);
				uvIndex++;
			}
		}
	}
	// }eAƂ̃N
	MaterialManager* materialManager = scene->getMaterialManager();
	Material* material = materialManager->search(materialName_);
	if(material == NULL){
		MayaErrorOut(String("TranslationRigidMesh::convertToLamp() ") + name_ +
			"ɐڑĂ}eA" + materialName_ + "܂ ");
		return false;
	}
	mesh->setMaterial(material);
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
